/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.jmx;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.BaseServerConfigLoader;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.enterprise.EnterpriseNeoServer;
import org.neo4j.server.enterprise.helpers.EnterpriseServerBuilder;
import org.neo4j.server.enterprise.jmx.ServerManagement;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.TargetDirectory;

public class ServerManagementTest {
    private final CleanupRule cleanup = new CleanupRule();
    private final TargetDirectory.TestDirectory baseDir = TargetDirectory.testDirForTest(this.getClass());
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.baseDir).around((TestRule)this.cleanup);

    @Test
    public void shouldBeAbleToRestartServer() throws Exception {
        String dbDirectory1 = this.baseDir.directory("db1").getAbsolutePath();
        String dbDirectory2 = this.baseDir.directory("db2").getAbsolutePath();
        Config config = new BaseServerConfigLoader().loadConfig(null, EnterpriseServerBuilder.server().withDefaultDatabaseTuning().usingDatabaseDir(dbDirectory1).createPropertiesFiles(), (Log)NullLog.getInstance(), new Pair[0]);
        NeoServer server = (NeoServer)this.cleanup.add((Object)new EnterpriseNeoServer(config, (GraphDatabaseFacadeFactory.Dependencies)ServerManagementTest.graphDbDependencies(), (LogProvider)NullLogProvider.getInstance()));
        server.start();
        Assert.assertNotNull((Object)server.getDatabase().getGraph());
        Assert.assertEquals((Object)dbDirectory1, (Object)server.getDatabase().getLocation());
        config.augment(MapUtil.stringMap((String[])new String[]{ServerSettings.legacy_db_location.name(), dbDirectory2}));
        ServerManagement bean = new ServerManagement(server);
        bean.restartServer();
        Assert.assertNotNull((Object)server.getDatabase().getGraph());
        Assert.assertEquals((Object)dbDirectory2, (Object)server.getDatabase().getLocation());
    }

    private static GraphDatabaseDependencies graphDbDependencies() {
        return GraphDatabaseDependencies.newDependencies().userLogProvider((LogProvider)NullLogProvider.getInstance());
    }
}

