/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.enterprise.EnterpriseNeoServer;

public class ServerClassNameTest {
    @Test
    public void shouldMaintainNamingOfCommunityNeoServerSoThatTheNeo4jEditionIsCorrectlyShownToRESTAPICallers() throws Exception {
        Assert.assertEquals((String)this.getErrorMessage(CommunityNeoServer.class), (Object)"communityneoserver", (Object)CommunityNeoServer.class.getSimpleName().toLowerCase());
    }

    @Test
    public void shouldMaintainNamingOfEnterpriseNeoServerSoThatTheNeo4jEditionIsCorrectlyShownToRESTAPICallers() throws Exception {
        Assert.assertEquals((String)this.getErrorMessage(EnterpriseNeoServer.class), (Object)"enterpriseneoserver", (Object)EnterpriseNeoServer.class.getSimpleName().toLowerCase());
    }

    private String getErrorMessage(Class<? extends AbstractNeoServer> neoServerClass) {
        return "The " + neoServerClass.getSimpleName() + " class appears to have been renamed. There is a strict " + "dependency from the REST API VersionAndEditionService on the name of that class. If you want " + "to change the name of that class, then remember to change VersionAndEditionService, " + "VersionAndEditionServiceTest and, of course, this test. ";
    }
}

