/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.functional;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.netty.channel.ChannelException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DumpPortListenerOnNettyBindFailure
implements TestRule {
    private final PrintWriter out;

    public DumpPortListenerOnNettyBindFailure() {
        this(System.err);
    }

    public DumpPortListenerOnNettyBindFailure(OutputStream out) {
        this(new PrintWriter(out, true));
    }

    public DumpPortListenerOnNettyBindFailure(Writer out) {
        this.out = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out, true);
    }

    public Statement apply(final Statement base, Description description) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return base;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                catch (Throwable failure) {
                    for (Throwable cause = failure; cause != null; cause = cause.getCause()) {
                        int port;
                        if (!(cause instanceof ChannelException)) continue;
                        String message = cause.getMessage();
                        String portString = message.substring(message.lastIndexOf(58) + 1);
                        try {
                            port = Integer.parseInt(portString);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        DumpPortListenerOnNettyBindFailure.this.dumpListenersOn(port);
                    }
                    throw failure;
                }
            }
        };
    }

    public void dumpListenersOn(int port) {
        try {
            Process lsof = new ProcessBuilder("lsof", "-i:" + port).redirectErrorStream(true).start();
            lsof.waitFor();
            this.out.println(DumpPortListenerOnNettyBindFailure.readAll(lsof.getInputStream()));
        }
        catch (Exception e) {
            this.out.println("Could not determine the process listening on :" + port);
        }
    }

    private static String readAll(InputStream stream) throws IOException {
        String line;
        StringBuilder message = new StringBuilder();
        BufferedReader err = new BufferedReader(new InputStreamReader(stream));
        while (null != (line = err.readLine())) {
            message.append(line).append('\n');
        }
        err.close();
        return message.toString();
    }
}

