/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.server.BaseBootstrapperTest;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.enterprise.EnterpriseBootstrapper;
import org.neo4j.server.enterprise.EnterpriseServerSettings;

public class EnterpriseBootstrapperTest
extends BaseBootstrapperTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    protected Bootstrapper newBootstrapper() {
        return new EnterpriseBootstrapper();
    }

    @Test
    public void shouldBeAbleToStartInSingleMode() throws Exception {
        int resultCode = CommunityBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])this.commandLineConfig(new String[]{"-c", this.configOption(EnterpriseServerSettings.mode.name(), "SINGLE"), "-c", this.configOption(DatabaseManagementSystemSettings.data_directory.name(), ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)DatabaseManagementSystemSettings.data_directory)), "-c", this.configOption(GraphDatabaseSettings.auth_store.name(), ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)GraphDatabaseSettings.auth_store)), "-c", this.configOption(ServerSettings.tls_key_file.name(), ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)ServerSettings.tls_key_file)), "-c", this.configOption(ServerSettings.tls_certificate_file.name(), ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)ServerSettings.tls_certificate_file))}));
        Assert.assertEquals((long)0L, (long)resultCode);
        Assert.assertNotNull((Object)this.bootstrapper.getServer());
    }

    @Test
    public void shouldBeAbleToStartInHAMode() throws Exception {
        int resultCode = CommunityBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])this.commandLineConfig(new String[]{"-c", this.configOption(EnterpriseServerSettings.mode.name(), "HA"), "-c", this.configOption(ClusterSettings.server_id.name(), "1"), "-c", this.configOption(ClusterSettings.initial_hosts.name(), "127.0.0.1:5001"), "-c", this.configOption(DatabaseManagementSystemSettings.data_directory.name(), ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)DatabaseManagementSystemSettings.data_directory)), "-c", this.configOption(GraphDatabaseSettings.auth_store.name(), ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)GraphDatabaseSettings.auth_store)), "-c", this.configOption(ServerSettings.tls_key_file.name(), ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)ServerSettings.tls_key_file)), "-c", this.configOption(ServerSettings.tls_certificate_file.name(), ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)ServerSettings.tls_certificate_file))}));
        Assert.assertEquals((long)0L, (long)resultCode);
        Assert.assertNotNull((Object)this.bootstrapper.getServer());
    }
}

