/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Predicate;
import org.jboss.netty.channel.ChannelException;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.client.ClusterClientModule;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.StoreLogService;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;

public class StandaloneClusterClient {
    private final LifeSupport life;
    private final Timer timer;

    private StandaloneClusterClient(LifeSupport life) {
        this.life = life;
        this.timer = new Timer(true);
        this.addShutdownHook();
        life.start();
    }

    protected void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                StandaloneClusterClient.this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        System.err.println("Failed to stop in a reasonable time, terminating...");
                        Runtime.getRuntime().halt(1);
                    }
                }, 4000L);
                StandaloneClusterClient.this.life.shutdown();
            }
        });
    }

    public static void main(String[] args) throws IOException {
        try {
            LifeSupport life = new LifeSupport();
            life.add((Lifecycle)new Neo4jJobScheduler());
            new ClusterClientModule(life, new Dependencies(), new Monitors(), StandaloneClusterClient.getConfig(args), StandaloneClusterClient.logService((FileSystemAbstraction)new DefaultFileSystemAbstraction()), (ElectionCredentialsProvider)new NotElectableElectionCredentialsProvider());
            new StandaloneClusterClient(life);
        }
        catch (LifecycleException e) {
            Throwable cause = Exceptions.peel((Throwable)e, (Predicate)Predicates.instanceOf(LifecycleException.class));
            if (cause instanceof ChannelException) {
                System.err.println("ERROR: " + cause.getMessage() + (cause.getCause() != null ? ", caused by:" + cause.getCause().getMessage() : ""));
            }
            System.err.println("ERROR: Unknown error");
            throw e;
        }
    }

    private static Config getConfig(String[] args) throws IOException {
        HashMap<String, String> config = new HashMap<String, String>();
        String configPath = System.getProperty("org.neo4j.config.file");
        if (configPath != null) {
            File configFile = new File(configPath);
            if (configFile.exists()) {
                config.putAll(MapUtil.load((File)configFile));
            } else {
                throw new IllegalArgumentException(configFile + " doesn't exist");
            }
        }
        config.putAll(Args.parse((String[])args).asMap());
        StandaloneClusterClient.verifyConfig(config);
        return new Config(config);
    }

    private static void verifyConfig(Map<String, String> config) {
        if (!config.containsKey(ClusterSettings.initial_hosts.name())) {
            System.err.println("No initial hosts to connect to supplied");
            System.exit(1);
        }
        if (!config.containsKey(ClusterSettings.server_id.name())) {
            System.err.println("No server id specified");
            System.exit(1);
        }
    }

    private static LogService logService(FileSystemAbstraction fileSystem) throws IOException {
        String logDir = System.getProperty("org.neo4j.cluster.logdirectory", "data/log");
        return StoreLogService.withUserLogProvider((LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out)).inStoreDirectory(fileSystem, new File(logDir));
    }
}

