/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.jmx;

import java.io.File;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ConfigLoader;
import org.neo4j.server.enterprise.EnterpriseNeoServer;
import org.neo4j.server.enterprise.helpers.EnterpriseServerBuilder;
import org.neo4j.server.enterprise.jmx.ServerManagement;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.TargetDirectory;

public class ServerManagementTest {
    private final CleanupRule cleanup = new CleanupRule();
    private final TargetDirectory.TestDirectory baseDir = TargetDirectory.testDirForTest(this.getClass());
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.baseDir).around((TestRule)this.cleanup);

    @Test
    public void shouldBeAbleToRestartServer() throws Exception {
        String dataDirectory1 = this.baseDir.directory("data1").getAbsolutePath();
        String dataDirectory2 = this.baseDir.directory("data2").getAbsolutePath();
        Config config = new ConfigLoader(CommunityBootstrapper.settingsClasses).loadConfig(Optional.of(this.baseDir.directory()), EnterpriseServerBuilder.server().withDefaultDatabaseTuning().usingDataDir(dataDirectory1).createConfigFiles(), new Pair[]{Pair.pair((Object)GraphDatabaseSettings.logs_directory.name(), (Object)this.baseDir.directory("logs").getPath())});
        NeoServer server = (NeoServer)this.cleanup.add((Object)new EnterpriseNeoServer(config, (GraphDatabaseFacadeFactory.Dependencies)ServerManagementTest.graphDbDependencies(), (LogProvider)NullLogProvider.getInstance()));
        server.start();
        Assert.assertNotNull((Object)server.getDatabase().getGraph());
        Assert.assertEquals((Object)((File)config.get(DatabaseManagementSystemSettings.database_path)).getAbsolutePath(), (Object)server.getDatabase().getLocation());
        config.augment(MapUtil.stringMap((String[])new String[]{DatabaseManagementSystemSettings.data_directory.name(), dataDirectory2}));
        ServerManagement bean = new ServerManagement(server);
        bean.restartServer();
        Assert.assertNotNull((Object)server.getDatabase().getGraph());
        Assert.assertEquals((Object)((File)config.get(DatabaseManagementSystemSettings.database_path)).getAbsolutePath(), (Object)server.getDatabase().getLocation());
    }

    private static GraphDatabaseDependencies graphDbDependencies() {
        return GraphDatabaseDependencies.newDependencies().userLogProvider((LogProvider)NullLogProvider.getInstance());
    }
}

