/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.util.Arrays;
import java.util.Map;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.coreedge.core.CoreEdgeClusterSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.NeoServer;
import org.neo4j.server.enterprise.EnterpriseNeoServer;
import org.neo4j.server.enterprise.EnterpriseServerSettings;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;

public class EnterpriseBootstrapper
extends CommunityBootstrapper {
    protected NeoServer createNeoServer(Config configurator, GraphDatabaseDependencies dependencies, LogProvider userLogProvider) {
        return new EnterpriseNeoServer(configurator, (GraphDatabaseFacadeFactory.Dependencies)dependencies, userLogProvider);
    }

    protected Iterable<Class<?>> settingsClasses(Map<String, String> settings) {
        if (this.isHAMode(settings)) {
            return Iterables.concat((Iterable[])new Iterable[]{super.settingsClasses(settings), Arrays.asList(HaSettings.class, ClusterSettings.class, SecuritySettings.class)});
        }
        if (this.isCEMode(settings)) {
            return Iterables.concat((Iterable[])new Iterable[]{super.settingsClasses(settings), Arrays.asList(CoreEdgeClusterSettings.class, SecuritySettings.class)});
        }
        return super.settingsClasses(settings);
    }

    private boolean isHAMode(Map<String, String> settings) {
        return ((String)new Config(settings, new Class[]{EnterpriseServerSettings.class}).get(EnterpriseServerSettings.mode)).equals("HA");
    }

    private boolean isCEMode(Map<String, String> settings) {
        String mode = (String)new Config(settings, new Class[]{EnterpriseServerSettings.class}).get(EnterpriseServerSettings.mode);
        return mode.equals("CORE") || mode.equals("EDGE");
    }
}

