/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.server.BaseBootstrapperTest;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.ServerBootstrapper;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.enterprise.EnterpriseBootstrapper;
import org.neo4j.server.enterprise.EnterpriseEntryPoint;
import org.neo4j.server.enterprise.EnterpriseServerSettings;

public class EnterpriseBootstrapperTest
extends BaseBootstrapperTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    protected ServerBootstrapper newBootstrapper() {
        return new EnterpriseBootstrapper();
    }

    protected void start(String[] args) {
        EnterpriseEntryPoint.start((String[])args);
    }

    protected void stop(String[] args) {
        EnterpriseEntryPoint.stop((String[])args);
    }

    @Test
    public void shouldBeAbleToStartInSingleMode() throws Exception {
        int resultCode = ServerBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"-c", this.configOption(EnterpriseServerSettings.mode, "SINGLE"), "-c", this.configOption(DatabaseManagementSystemSettings.data_directory, ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)DatabaseManagementSystemSettings.data_directory)), "-c", this.configOption(GraphDatabaseSettings.logs_directory, this.tempDir.getRoot().getAbsolutePath()), "-c", this.configOption(ServerSettings.certificates_directory, ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)ServerSettings.certificates_directory)), "-c", "dbms.connector.1.type=HTTP", "-c", "dbms.connector.1.enabled=true"});
        Assert.assertEquals((long)0L, (long)resultCode);
        org.neo4j.test.assertion.Assert.assertEventually((String)"Server was not started", () -> ((ServerBootstrapper)this.bootstrapper).isRunning(), (Matcher)Matchers.is((Object)true), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    @Test
    public void shouldBeAbleToStartInHAMode() throws Exception {
        int resultCode = ServerBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"-c", this.configOption(EnterpriseServerSettings.mode, "HA"), "-c", this.configOption(ClusterSettings.server_id, "1"), "-c", this.configOption(ClusterSettings.initial_hosts, "127.0.0.1:5001"), "-c", this.configOption(DatabaseManagementSystemSettings.data_directory, ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)DatabaseManagementSystemSettings.data_directory)), "-c", this.configOption(GraphDatabaseSettings.logs_directory, this.tempDir.getRoot().getAbsolutePath()), "-c", this.configOption(ServerSettings.certificates_directory, ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)ServerSettings.certificates_directory)), "-c", "dbms.connector.1.type=HTTP", "-c", "dbms.connector.1.enabled=true"});
        Assert.assertEquals((long)0L, (long)resultCode);
        org.neo4j.test.assertion.Assert.assertEventually((String)"Server was not started", () -> ((ServerBootstrapper)this.bootstrapper).isRunning(), (Matcher)Matchers.is((Object)true), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }
}

