/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.server.rest.MasterInfoService;

public class MasterInfoServiceTest {
    @Test
    public void masterShouldRespond200AndTrueWhenMaster() throws Exception {
        HighlyAvailableGraphDatabase database = (HighlyAvailableGraphDatabase)Mockito.mock(HighlyAvailableGraphDatabase.class);
        Mockito.when((Object)database.role()).thenReturn((Object)"master");
        MasterInfoService service = new MasterInfoService(null, (GraphDatabaseService)database);
        Response response = service.isMaster();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"true", (Object)String.valueOf(response.getEntity()));
    }

    @Test
    public void masterShouldRespond404AndFalseWhenSlave() throws Exception {
        HighlyAvailableGraphDatabase database = (HighlyAvailableGraphDatabase)Mockito.mock(HighlyAvailableGraphDatabase.class);
        Mockito.when((Object)database.role()).thenReturn((Object)"slave");
        MasterInfoService service = new MasterInfoService(null, (GraphDatabaseService)database);
        Response response = service.isMaster();
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)"false", (Object)String.valueOf(response.getEntity()));
    }

    @Test
    public void masterShouldRespond404AndUNKNOWNWhenUnknown() throws Exception {
        HighlyAvailableGraphDatabase database = (HighlyAvailableGraphDatabase)Mockito.mock(HighlyAvailableGraphDatabase.class);
        Mockito.when((Object)database.role()).thenReturn((Object)"unknown");
        MasterInfoService service = new MasterInfoService(null, (GraphDatabaseService)database);
        Response response = service.isMaster();
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)"UNKNOWN", (Object)String.valueOf(response.getEntity()));
    }

    @Test
    public void slaveShouldRespond200AndTrueWhenSlave() throws Exception {
        HighlyAvailableGraphDatabase database = (HighlyAvailableGraphDatabase)Mockito.mock(HighlyAvailableGraphDatabase.class);
        Mockito.when((Object)database.role()).thenReturn((Object)"slave");
        MasterInfoService service = new MasterInfoService(null, (GraphDatabaseService)database);
        Response response = service.isSlave();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"true", (Object)String.valueOf(response.getEntity()));
    }

    @Test
    public void slaveShouldRespond404AndFalseWhenMaster() throws Exception {
        HighlyAvailableGraphDatabase database = (HighlyAvailableGraphDatabase)Mockito.mock(HighlyAvailableGraphDatabase.class);
        Mockito.when((Object)database.role()).thenReturn((Object)"master");
        MasterInfoService service = new MasterInfoService(null, (GraphDatabaseService)database);
        Response response = service.isSlave();
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)"false", (Object)String.valueOf(response.getEntity()));
    }

    @Test
    public void slaveShouldRespond404AndUNKNOWNWhenUnknown() throws Exception {
        HighlyAvailableGraphDatabase database = (HighlyAvailableGraphDatabase)Mockito.mock(HighlyAvailableGraphDatabase.class);
        Mockito.when((Object)database.role()).thenReturn((Object)"unknown");
        MasterInfoService service = new MasterInfoService(null, (GraphDatabaseService)database);
        Response response = service.isSlave();
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)"UNKNOWN", (Object)String.valueOf(response.getEntity()));
    }

    @Test
    public void shouldReportMasterAsGenerallyAvailableForTransactionProcessing() throws Exception {
        HighlyAvailableGraphDatabase database = (HighlyAvailableGraphDatabase)Mockito.mock(HighlyAvailableGraphDatabase.class);
        Mockito.when((Object)database.role()).thenReturn((Object)"master");
        MasterInfoService service = new MasterInfoService(null, (GraphDatabaseService)database);
        Response response = service.isAvailable();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"master", (Object)String.valueOf(response.getEntity()));
    }

    @Test
    public void shouldReportSlaveAsGenerallyAvailableForTransactionProcessing() throws Exception {
        HighlyAvailableGraphDatabase database = (HighlyAvailableGraphDatabase)Mockito.mock(HighlyAvailableGraphDatabase.class);
        Mockito.when((Object)database.role()).thenReturn((Object)"slave");
        MasterInfoService service = new MasterInfoService(null, (GraphDatabaseService)database);
        Response response = service.isAvailable();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"slave", (Object)String.valueOf(response.getEntity()));
    }

    @Test
    public void shouldReportNonMasterOrSlaveAsUnavailableForTransactionProcessing() throws Exception {
        HighlyAvailableGraphDatabase database = (HighlyAvailableGraphDatabase)Mockito.mock(HighlyAvailableGraphDatabase.class);
        Mockito.when((Object)database.role()).thenReturn((Object)"unknown");
        MasterInfoService service = new MasterInfoService(null, (GraphDatabaseService)database);
        Response response = service.isAvailable();
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)"UNKNOWN", (Object)String.valueOf(response.getEntity()));
    }
}

