/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.neo4j.coreedge.raft.roles.Role;
import org.neo4j.coreedge.server.core.CoreGraphDatabase;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.server.rest.CoreDatabaseAvailabilityDiscoveryRepresentation;
import org.neo4j.server.rest.management.AdvertisableService;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;

@Path(value="server/core")
public class CoreDatabaseAvailabilityService
implements AdvertisableService {
    public static final String BASE_PATH = "server/core";
    public static final String IS_WRITABLE_PATH = "/writable";
    public static final String IS_AVAILABLE_PATH = "/available";
    private final OutputFormat output;
    private final CoreGraphDatabase coreDatabase;

    public CoreDatabaseAvailabilityService(@Context OutputFormat output, @Context GraphDatabaseService db) {
        this.output = output;
        this.coreDatabase = db instanceof CoreGraphDatabase ? (CoreGraphDatabase)db : null;
    }

    @GET
    public Response discover() throws BadInputException {
        if (this.coreDatabase == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String isSlaveUri = IS_WRITABLE_PATH;
        return this.output.ok((Representation)new CoreDatabaseAvailabilityDiscoveryRepresentation(BASE_PATH, isSlaveUri));
    }

    @GET
    @Path(value="/writable")
    public Response isWritable() throws BadInputException {
        if (this.coreDatabase == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (this.coreDatabase.getRole() == Role.LEADER) {
            return this.positiveResponse();
        }
        return this.negativeResponse();
    }

    @GET
    @Path(value="/available")
    public Response isAvailable() {
        if (this.coreDatabase == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return this.positiveResponse();
    }

    private Response negativeResponse() {
        return this.plainTextResponse(Response.Status.NOT_FOUND, "false");
    }

    private Response positiveResponse() {
        return this.plainTextResponse(Response.Status.OK, "true");
    }

    private Response plainTextResponse(Response.Status status, String entityBody) {
        return Response.status((Response.Status)status).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)entityBody).build();
    }

    public String getName() {
        return "core";
    }

    public String getServerPath() {
        return BASE_PATH;
    }
}

