/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.neo4j.coreedge.server.edge.EdgeGraphDatabase;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.server.rest.management.AdvertisableService;
import org.neo4j.server.rest.repr.OutputFormat;

@Path(value="server/edge")
public class EdgeDatabaseAvailabilityService
implements AdvertisableService {
    public static final String BASE_PATH = "server/edge";
    public static final String IS_AVAILABLE_PATH = "/available";
    private final EdgeGraphDatabase edgeDatabase;

    public EdgeDatabaseAvailabilityService(@Context OutputFormat output, @Context GraphDatabaseService db) {
        this.edgeDatabase = db instanceof EdgeGraphDatabase ? (EdgeGraphDatabase)db : null;
    }

    @GET
    @Path(value="/available")
    public Response isAvailable() {
        if (this.edgeDatabase == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return this.positiveResponse();
    }

    private Response positiveResponse() {
        return this.plainTextResponse(Response.Status.OK, "true");
    }

    private Response plainTextResponse(Response.Status status, String entityBody) {
        return Response.status((Response.Status)status).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)entityBody).build();
    }

    public String getName() {
        return "edge";
    }

    public String getServerPath() {
        return BASE_PATH;
    }
}

