/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.neo4j.bolt.BoltKernelExtension;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.enterprise.helpers.EnterpriseServerBuilder;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.security.CommunityServerTestBase;
import org.neo4j.server.rest.security.RESTSubject;
import org.neo4j.server.security.enterprise.auth.EnterpriseAuthManager;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.NeoInteractionLevel;
import org.neo4j.test.server.HTTP;

public class NeoFullRESTInteraction
extends CommunityServerTestBase
implements NeoInteractionLevel<RESTSubject> {
    String COMMIT_PATH = "db/data/transaction/commit";
    String POST = "POST";
    EnterpriseAuthManager authManager;

    public NeoFullRESTInteraction() throws IOException {
        this.server = EnterpriseServerBuilder.server().withProperty(GraphDatabaseSettings.boltConnector((String)"0").enabled.name(), "true").withProperty(GraphDatabaseSettings.boltConnector((String)"0").encryption_level.name(), GraphDatabaseSettings.BoltConnector.EncryptionLevel.OPTIONAL.name()).withProperty(BoltKernelExtension.Settings.tls_key_file.name(), NeoInteractionLevel.tempPath((String)"key", (String)".key")).withProperty(BoltKernelExtension.Settings.tls_certificate_file.name(), NeoInteractionLevel.tempPath((String)"cert", (String)".cert")).withProperty(GraphDatabaseSettings.auth_enabled.name(), Boolean.toString(true)).withProperty(GraphDatabaseSettings.auth_manager.name(), "enterprise-auth-manager").build();
        this.server.start();
        this.authManager = (EnterpriseAuthManager)this.server.getDependencyResolver().resolveDependency(EnterpriseAuthManager.class);
    }

    public EnterpriseUserManager getManager() {
        return this.authManager.getUserManager();
    }

    public GraphDatabaseFacade getGraph() {
        return this.server.getDatabase().getGraph();
    }

    public InternalTransaction startTransactionAsUser(RESTSubject subject) throws Throwable {
        AuthSubject authSubject = this.authManager.login(AuthToken.newBasicAuthToken((String)subject.username, (String)subject.password));
        return this.getGraph().beginTransaction(KernelTransaction.Type.explicit, (AccessMode)authSubject);
    }

    public String executeQuery(RESTSubject subject, String call, Map<String, Object> params, Consumer<ResourceIterator<Map<String, Object>>> resultConsumer) {
        String escapedCall = call.replace("'", "\\'").replace("\"", "\\\"");
        HTTP.RawPayload payload = HTTP.RawPayload.quotedJson((String)("{'statements':[{'statement':'" + escapedCall + "'}]}"));
        HTTP.Response response = HTTP.withHeaders((String[])new String[]{"Authorization", subject.principalCredentials}).request(this.POST, this.commitURL(), (Object)payload);
        try {
            String error = this.parseErrorMessage(response);
            if (!error.isEmpty()) {
                return error;
            }
            JsonNode data = JsonHelper.jsonNode((String)response.rawContent());
            if (data.has("results") && data.get("results").has(0)) {
                JsonNode firstResult = data.get("results").get(0);
                RESTResult result = new RESTResult(firstResult);
                resultConsumer.accept(result);
            }
        }
        catch (JsonParseException e) {
            Assert.fail((String)"Unexpected error parsing Json!");
        }
        return "";
    }

    public RESTSubject login(String username, String password) throws Exception {
        String principalCredentials = this.challengeResponse(username, password);
        return new RESTSubject(username, password, principalCredentials);
    }

    private HTTP.Response authenticate(String principalCredentials) {
        return HTTP.withHeaders((String[])new String[]{"Authorization", principalCredentials}).request(this.POST, this.commitURL());
    }

    public void logout(RESTSubject subject) {
    }

    public void updateAuthToken(RESTSubject subject, String username, String password) {
        subject.principalCredentials = this.challengeResponse(username, password);
    }

    public String nameOf(RESTSubject subject) {
        return subject.username;
    }

    public void tearDown() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void assertAuthenticated(RESTSubject subject) {
        Assert.assertThat((Object)this.authenticate(subject.principalCredentials).status(), (Matcher)Matchers.equalTo((Object)200));
    }

    public void assertPasswordChangeRequired(RESTSubject subject) throws Exception {
        HTTP.Response response = this.authenticate(subject.principalCredentials);
        Assert.assertThat((Object)response.status(), (Matcher)Matchers.equalTo((Object)403));
        Assert.assertThat((Object)this.parseErrorMessage(response), (Matcher)Matchers.containsString((String)"User is required to change their password."));
    }

    public void assertInitFailed(RESTSubject subject) {
        Assert.assertThat((Object)this.authenticate(subject.principalCredentials).status(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)200)));
    }

    private String parseErrorMessage(HTTP.Response response) {
        try {
            JsonNode firstError;
            JsonNode data = JsonHelper.jsonNode((String)response.rawContent());
            if (data.has("errors") && data.get("errors").has(0) && (firstError = data.get("errors").get(0)).has("message")) {
                return firstError.get("message").asText();
            }
        }
        catch (JsonParseException e) {
            Assert.fail((String)"Unexpected error parsing Json!");
        }
        return "";
    }

    protected String commitURL() {
        return this.server.baseUri().resolve(this.COMMIT_PATH).toString();
    }

    class RESTResult
    implements ResourceIterator<Map<String, Object>> {
        private JsonNode data;
        private JsonNode columns;
        private int index = 0;

        public RESTResult(JsonNode fullResult) {
            this.data = fullResult.get("data");
            this.columns = fullResult.get("columns");
        }

        public void close() {
            this.index = this.data.size();
        }

        public boolean hasNext() {
            return this.index < this.data.size();
        }

        public Map<String, Object> next() {
            JsonNode row = this.data.get(this.index++).get("row");
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            for (int i = 0; i < this.columns.size(); ++i) {
                String key = this.columns.get(i).asText();
                JsonNode value = row.get(i);
                if (value instanceof TextNode) {
                    map.put(key, row.get(i).asText());
                    continue;
                }
                if (value instanceof ArrayNode) {
                    ArrayNode aNode = (ArrayNode)value;
                    ArrayList<String> listValue = new ArrayList<String>(aNode.size());
                    for (int j = 0; j < aNode.size(); ++j) {
                        listValue.add(aNode.get(j).asText());
                    }
                    map.put(key, listValue);
                    continue;
                }
                if (value instanceof ObjectNode) {
                    map.put(key, value);
                    continue;
                }
                if (value instanceof IntNode) {
                    map.put(key, value.getIntValue());
                    continue;
                }
                throw new RuntimeException("Unhandled REST value type '" + value.getClass() + "'. Need String (TextNode), List (ArrayNode), Object (ObjectNode) or int (IntNode).");
            }
            return map;
        }
    }
}

