/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.util.function.Function;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.kernel.configuration.Settings;

@Description(value="Settings available in the Enterprise server")
public interface EnterpriseServerSettings {
    @Description(value="Configure the operating mode of the database -- 'SINGLE' for stand-alone operation, 'HA' for operating as a member in a cluster, 'ARBITER' for an HA-only cluster member with no database, CORE for a core member of a Core/Edge cluster, or EDGE for an edge member of a Core/Edge cluster. ")
    public static final Setting<String> mode = Settings.setting((String)"dbms.mode", (Function)Settings.STRING, (String)"SINGLE");
    @Description(value="Configure the Neo4j Browser to time out logged in users after this idle period. Setting this to 0 indicates no limit.")
    public static final Setting<Long> browser_credentialTimeout = Settings.setting((String)"browser.credential_timeout", (Function)Settings.DURATION, (String)"0");
    @Description(value="Configure the Neo4j Browser to store or not store user credentials.")
    public static final Setting<Boolean> browser_retainConnectionCredentials = Settings.setting((String)"browser.retain_connection_credentials", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="Whitelist of hosts for the Neo4j Browser to be allowed to fetch content from.")
    public static final Setting<String> browser_remoteContentHostnameWhitelist = Settings.setting((String)"browser.remote_content_hostname_whitelist", (Function)Settings.STRING, (String)"http://guides.neo4j.com,https://guides.neo4j.com,http://localhost,https://localhost");
    @Description(value="Configure the policy for outgoing Neo4j Browser connections.")
    public static final Setting<Boolean> browser_allowOutgoingBrowserConnections = Settings.setting((String)"browser.allow_outgoing_connections", (Function)Settings.BOOLEAN, (String)"true");
}

