/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.functional;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.MetricsTestHelper;
import org.neo4j.metrics.source.server.ServerMetrics;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.enterprise.helpers.EnterpriseServerBuilder;

public class ServerMetricsIT {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldShowServerMetrics() throws Throwable {
        String path = this.folder.getRoot().getAbsolutePath();
        File metricsPath = new File(path + "/metrics");
        CommunityNeoServer server = EnterpriseServerBuilder.server().usingDataDir(path).withProperty(MetricsSettings.metricsEnabled.name(), "true").withProperty(MetricsSettings.csvEnabled.name(), "true").withProperty(MetricsSettings.csvPath.name(), metricsPath.getPath()).withProperty(MetricsSettings.csvInterval.name(), "100ms").persistent().build();
        try {
            server.start();
            String host = "http://localhost:7474" + ServerSettings.rest_api_path.getDefaultValue() + "/transaction/commit";
            for (int i = 0; i < 5; ++i) {
                ClientResponse r = (ClientResponse)((WebResource.Builder)Client.create().resource(host).accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)"{ 'statements': [ { 'statement': 'CREATE ()' } ] }");
                Assert.assertEquals((long)200L, (long)r.getStatus());
            }
            this.assertMetricsExists(metricsPath, ServerMetrics.THREAD_JETTY_ALL);
            this.assertMetricsExists(metricsPath, ServerMetrics.THREAD_JETTY_IDLE);
        }
        finally {
            server.stop();
        }
    }

    private void assertMetricsExists(File metricsPath, String meticsName) throws IOException, InterruptedException {
        File file = MetricsTestHelper.metricsCsv((File)metricsPath, (String)meticsName);
        long threadCount = MetricsTestHelper.readLongValue((File)file);
        Assert.assertThat((Object)threadCount, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }
}

