/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.server.rest.management.AdvertisableService;
import org.neo4j.server.rest.repr.OutputFormat;

@Path(value="server/read-replica")
public class ReadReplicaDatabaseAvailabilityService
implements AdvertisableService {
    public static final String BASE_PATH = "server/read-replica";
    public static final String IS_AVAILABLE_PATH = "/available";
    private final ReadReplicaGraphDatabase readReplica;

    public ReadReplicaDatabaseAvailabilityService(@Context OutputFormat output, @Context GraphDatabaseService db) {
        this.readReplica = db instanceof ReadReplicaGraphDatabase ? (ReadReplicaGraphDatabase)db : null;
    }

    @GET
    @Path(value="/available")
    public Response isAvailable() {
        if (this.readReplica == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return this.positiveResponse();
    }

    private Response positiveResponse() {
        return this.plainTextResponse(Response.Status.OK, "true");
    }

    private Response plainTextResponse(Response.Status status, String entityBody) {
        return Response.status((Response.Status)status).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)entityBody).build();
    }

    public String getName() {
        return "read-replica";
    }

    public String getServerPath() {
        return BASE_PATH;
    }
}

