/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.EnterpriseGraphDatabase;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;
import org.neo4j.logging.LogProvider;
import org.neo4j.metrics.source.server.ServerThreadView;
import org.neo4j.metrics.source.server.ServerThreadViewSetter;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.enterprise.modules.EnterpriseAuthorizationModule;
import org.neo4j.server.enterprise.modules.JMXManagementModule;
import org.neo4j.server.modules.AuthorizationModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.DatabaseRoleInfoServerModule;
import org.neo4j.server.rest.MasterInfoService;
import org.neo4j.server.rest.management.AdvertisableService;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.server.web.WebServer;

public class EnterpriseNeoServer
extends CommunityNeoServer {
    private static final LifecycleManagingDatabase.GraphFactory HA_FACTORY = (config, dependencies) -> {
        File storeDir = (File)config.get(DatabaseManagementSystemSettings.database_path);
        return new HighlyAvailableGraphDatabase(storeDir, config, dependencies);
    };
    private static final LifecycleManagingDatabase.GraphFactory ENTERPRISE_FACTORY = (config, dependencies) -> {
        File storeDir = (File)config.get(DatabaseManagementSystemSettings.database_path);
        return new EnterpriseGraphDatabase(storeDir, config, dependencies);
    };
    private static final LifecycleManagingDatabase.GraphFactory CORE_FACTORY = (config, dependencies) -> {
        File storeDir = (File)config.get(DatabaseManagementSystemSettings.database_path);
        return new CoreGraphDatabase(storeDir, config, dependencies);
    };
    private static final LifecycleManagingDatabase.GraphFactory READ_REPLICA_FACTORY = (config, dependencies) -> {
        File storeDir = (File)config.get(DatabaseManagementSystemSettings.database_path);
        return new ReadReplicaGraphDatabase(storeDir, config, dependencies);
    };

    public EnterpriseNeoServer(Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
        super(config, EnterpriseNeoServer.createDbFactory(config), dependencies, logProvider);
    }

    protected static Database.Factory createDbFactory(Config config) {
        ClusterSettings.Mode mode = (ClusterSettings.Mode)config.get(ClusterSettings.mode);
        switch (mode) {
            case HA: {
                return LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)HA_FACTORY);
            }
            case ARBITER: {
                throw new IllegalArgumentException("The server cannot be started in ARBITER mode.");
            }
            case CORE: {
                return LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)CORE_FACTORY);
            }
            case READ_REPLICA: {
                return LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)READ_REPLICA_FACTORY);
            }
        }
        return LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)ENTERPRISE_FACTORY);
    }

    protected WebServer createWebServer() {
        Jetty9WebServer webServer = (Jetty9WebServer)super.createWebServer();
        webServer.setJettyCreatedCallback(jetty -> {
            final ThreadPool threadPool = jetty.getThreadPool();
            assert (threadPool != null);
            try {
                ServerThreadViewSetter setter = (ServerThreadViewSetter)this.database.getGraph().getDependencyResolver().resolveDependency(ServerThreadViewSetter.class);
                setter.set(new ServerThreadView(){

                    public int allThreads() {
                        return threadPool.getThreads();
                    }

                    public int idleThreads() {
                        return threadPool.getIdleThreads();
                    }
                });
            }
            catch (UnsatisfiedDependencyException unsatisfiedDependencyException) {
                // empty catch block
            }
        });
        return webServer;
    }

    protected AuthorizationModule createAuthorizationModule() {
        return new EnterpriseAuthorizationModule(this.webServer, this.authManagerSupplier, this.logProvider, this.getConfig(), this.getUriWhitelist());
    }

    protected Iterable<ServerModule> createServerModules() {
        return Iterables.mix((Iterable[])new Iterable[]{Arrays.asList(new DatabaseRoleInfoServerModule(this.webServer, this.getConfig(), this.logProvider), new JMXManagementModule((NeoServer)this)), super.createServerModules()});
    }

    public Iterable<AdvertisableService> getServices() {
        if (this.getDatabase().getGraph() instanceof HighlyAvailableGraphDatabase) {
            return Iterables.append((Object)new MasterInfoService(null, null), (Iterable)super.getServices());
        }
        return super.getServices();
    }

    protected Pattern[] getUriWhitelist() {
        ArrayList<Pattern> uriWhitelist = new ArrayList<Pattern>(Arrays.asList(super.getUriWhitelist()));
        if (!((Boolean)this.getConfig().get(HaSettings.ha_status_auth_enabled)).booleanValue()) {
            uriWhitelist.add(Pattern.compile("/db/manage/server/ha.*"));
        }
        return uriWhitelist.toArray(new Pattern[uriWhitelist.size()]);
    }
}

