/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.LongNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.neo4j.bolt.BoltKernelExtension;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.enterprise.api.security.EnterpriseAuthManager;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.enterprise.helpers.EnterpriseServerBuilder;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.security.CommunityServerTestBase;
import org.neo4j.server.rest.security.RESTSubject;
import org.neo4j.server.security.enterprise.auth.EnterpriseAuthAndUserManager;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.NeoInteractionLevel;
import org.neo4j.test.server.HTTP;

abstract class AbstractRESTInteraction
extends CommunityServerTestBase
implements NeoInteractionLevel<RESTSubject> {
    static final String POST = "POST";
    private EnterpriseAuthManager authManager;

    abstract String commitPath();

    abstract void consume(Consumer<ResourceIterator<Map<String, Object>>> var1, JsonNode var2);

    abstract HTTP.RawPayload constructQuery(String var1);

    protected abstract HTTP.Response authenticate(String var1);

    AbstractRESTInteraction(Map<String, String> config) throws IOException {
        EnterpriseServerBuilder builder = EnterpriseServerBuilder.server();
        builder = builder.withProperty(new BoltConnector((String)"bolt").type.name(), "BOLT").withProperty(new BoltConnector((String)"bolt").enabled.name(), "true").withProperty(new BoltConnector((String)"bolt").encryption_level.name(), BoltConnector.EncryptionLevel.OPTIONAL.name()).withProperty(BoltKernelExtension.Settings.tls_key_file.name(), NeoInteractionLevel.tempPath((String)"key", (String)".key")).withProperty(BoltKernelExtension.Settings.tls_certificate_file.name(), NeoInteractionLevel.tempPath((String)"cert", (String)".cert")).withProperty(GraphDatabaseSettings.auth_enabled.name(), Boolean.toString(true));
        for (Map.Entry<String, String> entry : config.entrySet()) {
            builder = builder.withProperty(entry.getKey(), entry.getValue());
        }
        this.server = builder.build();
        this.server.start();
        this.authManager = (EnterpriseAuthManager)this.server.getDependencyResolver().resolveDependency(EnterpriseAuthManager.class);
    }

    public EnterpriseUserManager getLocalUserManager() throws Exception {
        if (this.authManager instanceof EnterpriseAuthAndUserManager) {
            return ((EnterpriseAuthAndUserManager)this.authManager).getUserManager();
        }
        throw new Exception("The used configuration does not have a user manager");
    }

    public GraphDatabaseFacade getLocalGraph() {
        return this.server.getDatabase().getGraph();
    }

    public FileSystemAbstraction fileSystem() {
        return new DefaultFileSystemAbstraction();
    }

    public InternalTransaction beginLocalTransactionAsUser(RESTSubject subject, KernelTransaction.Type txType) throws Throwable {
        EnterpriseSecurityContext securityContext = this.authManager.login(AuthToken.newBasicAuthToken((String)subject.username, (String)subject.password));
        return this.getLocalGraph().beginTransaction(txType, (SecurityContext)securityContext);
    }

    public String executeQuery(RESTSubject subject, String call, Map<String, Object> params, Consumer<ResourceIterator<Map<String, Object>>> resultConsumer) {
        HTTP.RawPayload payload = this.constructQuery(call);
        HTTP.Response response = HTTP.withHeaders((String[])new String[]{"Authorization", subject.principalCredentials}).request(POST, this.commitURL(), (Object)payload);
        try {
            String error = this.parseErrorMessage(response);
            if (!error.isEmpty()) {
                return error;
            }
            this.consume(resultConsumer, JsonHelper.jsonNode((String)response.rawContent()));
        }
        catch (JsonParseException e) {
            Assert.fail((String)"Unexpected error parsing Json!");
        }
        return "";
    }

    public RESTSubject login(String username, String password) throws Exception {
        String principalCredentials = this.challengeResponse(username, password);
        return new RESTSubject(username, password, principalCredentials);
    }

    public void logout(RESTSubject subject) {
    }

    public void updateAuthToken(RESTSubject subject, String username, String password) {
        subject.principalCredentials = this.challengeResponse(username, password);
    }

    public String nameOf(RESTSubject subject) {
        return subject.username;
    }

    public void tearDown() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void assertAuthenticated(RESTSubject subject) {
        HTTP.Response authenticate = this.authenticate(subject.principalCredentials);
        Assert.assertThat((String)authenticate.rawContent(), (Object)authenticate.status(), (Matcher)Matchers.equalTo((Object)200));
    }

    public void assertPasswordChangeRequired(RESTSubject subject) throws Exception {
        HTTP.Response response = this.authenticate(subject.principalCredentials);
        Assert.assertThat((Object)response.status(), (Matcher)Matchers.equalTo((Object)403));
        Assert.assertThat((Object)this.parseErrorMessage(response), (Matcher)Matchers.containsString((String)"User is required to change their password."));
    }

    public void assertInitFailed(RESTSubject subject) {
        Assert.assertThat((Object)this.authenticate(subject.principalCredentials).status(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)200)));
    }

    public void assertSessionKilled(RESTSubject subject) {
    }

    public String getConnectionProtocol() {
        return "http";
    }

    private String parseErrorMessage(HTTP.Response response) {
        try {
            JsonNode firstError;
            JsonNode data = JsonHelper.jsonNode((String)response.rawContent());
            if (data.has("errors") && data.get("errors").has(0) && (firstError = data.get("errors").get(0)).has("message")) {
                return firstError.get("message").asText();
            }
        }
        catch (JsonParseException e) {
            Assert.fail((String)"Unexpected error parsing Json!");
        }
        return "";
    }

    String commitURL() {
        return this.server.baseUri().resolve(this.commitPath()).toString();
    }

    private Object getValue(JsonNode valueNode) {
        ArrayList<String> value;
        if (valueNode instanceof TextNode) {
            value = valueNode.asText();
        } else if (valueNode instanceof ObjectNode) {
            value = this.mapValue(valueNode.getFieldNames(), valueNode);
        } else if (valueNode instanceof ArrayNode) {
            ArrayNode aNode = (ArrayNode)valueNode;
            ArrayList<String> listValue = new ArrayList<String>(aNode.size());
            for (int j = 0; j < aNode.size(); ++j) {
                listValue.add(aNode.get(j).asText());
            }
            value = listValue;
        } else if (valueNode instanceof IntNode) {
            value = valueNode.getIntValue();
        } else if (valueNode instanceof LongNode) {
            value = valueNode.getLongValue();
        } else {
            if (valueNode.isNull()) {
                return null;
            }
            throw new RuntimeException(String.format("Unhandled REST value type '%s'. Need String (TextNode), List (ArrayNode), Object (ObjectNode), long (LongNode), or int (IntNode).", valueNode.getClass()));
        }
        return value;
    }

    private Map<String, Object> mapValue(Iterator<String> columns, JsonNode node) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        while (columns.hasNext()) {
            String key = columns.next();
            Object value = this.getValue(node.get(key));
            map.put(key, value);
        }
        return map;
    }

    abstract class AbstractRESTResult
    implements ResourceIterator<Map<String, Object>> {
        private JsonNode data;
        private JsonNode columns;
        private int index = 0;

        AbstractRESTResult(JsonNode fullResult) {
            this.data = fullResult.get("data");
            this.columns = fullResult.get("columns");
        }

        public void close() {
            this.index = this.data.size();
        }

        public boolean hasNext() {
            return this.index < this.data.size();
        }

        public Map<String, Object> next() {
            JsonNode row = this.getRow(this.data, this.index++);
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            for (int i = 0; i < this.columns.size(); ++i) {
                String key = this.columns.get(i).asText();
                Object value = AbstractRESTInteraction.this.getValue(row.get(i));
                map.put(key, value);
            }
            return map;
        }

        protected abstract JsonNode getRow(JsonNode var1, int var2);
    }
}

