/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.functional;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.enterprise.functional.DumpPortListenerOnNettyBindFailure;
import org.neo4j.server.enterprise.helpers.EnterpriseServerBuilder;

public class EnterpriseServerIT {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    @Rule
    public DumpPortListenerOnNettyBindFailure dumpPorts = new DumpPortListenerOnNettyBindFailure();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToStartInHAMode() throws Throwable {
        CommunityNeoServer server = EnterpriseServerBuilder.server().usingDataDir(this.folder.getRoot().getAbsolutePath()).withProperty(ClusterSettings.mode.name(), "HA").withProperty(ClusterSettings.server_id.name(), "1").withProperty(ClusterSettings.initial_hosts.name(), ":5001").persistent().build();
        try {
            server.start();
            server.getDatabase();
            Assert.assertThat((Object)server.getDatabase().getGraph(), (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(HighlyAvailableGraphDatabase.class)));
            Client client = Client.create();
            ClientResponse r = (ClientResponse)client.resource("http://localhost:7474/db/manage/server/ha").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((long)200L, (long)r.getStatus());
            Assert.assertThat((Object)r.getEntity(String.class), (Matcher)Matchers.containsString((String)"master"));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRequireAuthorizationForHAStatusEndpoints() throws Exception {
        CommunityNeoServer server = EnterpriseServerBuilder.server().withProperty(GraphDatabaseSettings.auth_enabled.name(), "true").usingDataDir(this.folder.getRoot().getAbsolutePath()).withProperty(ClusterSettings.mode.name(), "HA").withProperty(ClusterSettings.server_id.name(), "1").withProperty(ClusterSettings.initial_hosts.name(), ":5001").persistent().build();
        try {
            server.start();
            server.getDatabase();
            Assert.assertThat((Object)server.getDatabase().getGraph(), (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(HighlyAvailableGraphDatabase.class)));
            Client client = Client.create();
            ClientResponse r = (ClientResponse)client.resource("http://localhost:7474/db/manage/server/ha").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((long)401L, (long)r.getStatus());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAllowDisablingAuthorizationOnHAStatusEndpoints() throws Exception {
        CommunityNeoServer server = EnterpriseServerBuilder.server().withProperty(GraphDatabaseSettings.auth_enabled.name(), "true").withProperty(HaSettings.ha_status_auth_enabled.name(), "false").usingDataDir(this.folder.getRoot().getAbsolutePath()).withProperty(ClusterSettings.mode.name(), "HA").withProperty(ClusterSettings.server_id.name(), "1").withProperty(ClusterSettings.initial_hosts.name(), ":5001").persistent().build();
        try {
            server.start();
            server.getDatabase();
            Assert.assertThat((Object)server.getDatabase().getGraph(), (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(HighlyAvailableGraphDatabase.class)));
            Client client = Client.create();
            ClientResponse r = (ClientResponse)client.resource("http://localhost:7474/db/manage/server/ha").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((long)200L, (long)r.getStatus());
            Assert.assertThat((Object)r.getEntity(String.class), (Matcher)Matchers.containsString((String)"master"));
        }
        finally {
            server.stop();
        }
    }

    @After
    public void whoListensOn5001() {
        this.dumpPorts.dumpListenersOn(5001);
    }
}

