/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.NeoServer;
import org.neo4j.server.enterprise.helpers.EnterpriseServerBuilder;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.server.rest.UniqueStrings;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.GraphHolder;
import org.neo4j.test.TestData;
import org.neo4j.test.rule.SuppressOutput;

public class PropertyExistenceConstraintsIT
implements GraphHolder {
    private final Factory<String> labels = UniqueStrings.withPrefix((String)"label");
    private final Factory<String> properties = UniqueStrings.withPrefix((String)"property");
    private final Factory<String> relationshipTypes = UniqueStrings.withPrefix((String)"relationshipType");
    @Rule
    public TestData<Map<String, Node>> data = TestData.producedThrough((TestData.Producer)GraphDescription.createGraphFor((GraphHolder)this, (boolean)true));
    @Rule
    public TestData<RESTRequestGenerator> gen = TestData.producedThrough((TestData.Producer)RESTRequestGenerator.PRODUCER);
    private static NeoServer server;

    public GraphDatabaseService graphdb() {
        return server.getDatabase().getGraph();
    }

    @BeforeClass
    public static void initServer() throws Exception {
        SuppressOutput.suppressAll().call(() -> {
            EnterpriseServerBuilder serverBuilder = EnterpriseServerBuilder.server((LogProvider)NullLogProvider.getInstance());
            server = ServerHelper.createNonPersistentServer((CommunityServerBuilder)serverBuilder);
            return null;
        });
    }

    @AfterClass
    public static void stopServer() throws Exception {
        if (server != null) {
            SuppressOutput.suppressAll().call(() -> {
                server.stop();
                return null;
            });
        }
    }

    @Documented(value="Get a specific node property existence constraint.\nGet a specific node property existence constraint for a label and a property.")
    @Test
    @GraphDescription.Graph(nodes={})
    public void getLabelPropertyExistenceConstraint() throws JsonParseException {
        this.data.get();
        String labelName = (String)this.labels.newInstance();
        String propertyKey = (String)this.properties.newInstance();
        this.createLabelPropertyExistenceConstraint(labelName, propertyKey);
        String result = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(this.getSchemaConstraintLabelExistencePropertyUri(labelName, propertyKey)).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        HashMap<String, Object> constraint = new HashMap<String, Object>();
        constraint.put("type", ConstraintType.NODE_PROPERTY_EXISTENCE.name());
        constraint.put("label", labelName);
        constraint.put("property_keys", Collections.singletonList(propertyKey));
        Assert.assertThat((Object)serializedList, (Matcher)Matchers.hasItem(constraint));
    }

    @Documented(value="Get a specific relationship property existence constraint.\nGet a specific relationship property existence constraint for a label and a property.")
    @Test
    @GraphDescription.Graph(nodes={})
    public void getRelationshipTypePropertyExistenceConstraint() throws JsonParseException {
        this.data.get();
        String typeName = (String)this.relationshipTypes.newInstance();
        String propertyKey = (String)this.properties.newInstance();
        this.createRelationshipTypePropertyExistenceConstraint(typeName, propertyKey);
        String result = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(this.getSchemaRelationshipConstraintTypeExistencePropertyUri(typeName, propertyKey)).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        HashMap<String, Object> constraint = new HashMap<String, Object>();
        constraint.put("type", ConstraintType.RELATIONSHIP_PROPERTY_EXISTENCE.name());
        constraint.put("relationshipType", typeName);
        constraint.put("property_keys", Collections.singletonList(propertyKey));
        Assert.assertThat((Object)serializedList, (Matcher)Matchers.hasItem(constraint));
    }

    @Documented(value="Get all node property existence constraints for a label.")
    @Test
    @GraphDescription.Graph(nodes={})
    public void getLabelPropertyExistenceConstraints() throws JsonParseException {
        this.data.get();
        String labelName = (String)this.labels.newInstance();
        String propertyKey1 = (String)this.properties.newInstance();
        String propertyKey2 = (String)this.properties.newInstance();
        this.createLabelPropertyExistenceConstraint(labelName, propertyKey1);
        this.createLabelPropertyExistenceConstraint(labelName, propertyKey2);
        String result = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(this.getSchemaConstraintLabelExistenceUri(labelName)).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        HashMap<String, Object> constraint1 = new HashMap<String, Object>();
        constraint1.put("type", ConstraintType.NODE_PROPERTY_EXISTENCE.name());
        constraint1.put("label", labelName);
        constraint1.put("property_keys", Collections.singletonList(propertyKey1));
        HashMap<String, Object> constraint2 = new HashMap<String, Object>();
        constraint2.put("type", ConstraintType.NODE_PROPERTY_EXISTENCE.name());
        constraint2.put("label", labelName);
        constraint2.put("property_keys", Collections.singletonList(propertyKey2));
        Assert.assertThat((Object)serializedList, (Matcher)Matchers.hasItems((Object[])new Map[]{constraint1, constraint2}));
    }

    @Documented(value="Get all relationship property existence constraints for a type.")
    @Test
    @GraphDescription.Graph(nodes={})
    public void getRelationshipTypePropertyExistenceConstraints() throws JsonParseException {
        this.data.get();
        String typeName = (String)this.relationshipTypes.newInstance();
        String propertyKey1 = (String)this.properties.newInstance();
        String propertyKey2 = (String)this.properties.newInstance();
        this.createRelationshipTypePropertyExistenceConstraint(typeName, propertyKey1);
        this.createRelationshipTypePropertyExistenceConstraint(typeName, propertyKey2);
        String result = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(this.getSchemaRelationshipConstraintTypeExistenceUri(typeName)).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        HashMap<String, Object> constraint1 = new HashMap<String, Object>();
        constraint1.put("type", ConstraintType.RELATIONSHIP_PROPERTY_EXISTENCE.name());
        constraint1.put("relationshipType", typeName);
        constraint1.put("property_keys", Collections.singletonList(propertyKey1));
        HashMap<String, Object> constraint2 = new HashMap<String, Object>();
        constraint2.put("type", ConstraintType.RELATIONSHIP_PROPERTY_EXISTENCE.name());
        constraint2.put("relationshipType", typeName);
        constraint2.put("property_keys", Collections.singletonList(propertyKey2));
        Assert.assertThat((Object)serializedList, (Matcher)Matchers.hasItems((Object[])new Map[]{constraint1, constraint2}));
    }

    @Documented(value="Get all constraints for a label.")
    @Test
    @GraphDescription.Graph(nodes={})
    public void getLabelPropertyConstraints() throws JsonParseException {
        this.data.get();
        String labelName = (String)this.labels.newInstance();
        String propertyKey1 = (String)this.properties.newInstance();
        String propertyKey2 = (String)this.properties.newInstance();
        this.createLabelUniquenessPropertyConstraint(labelName, propertyKey1);
        this.createLabelPropertyExistenceConstraint(labelName, propertyKey2);
        String result = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(this.getSchemaConstraintLabelUri(labelName)).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        HashMap<String, Object> constraint1 = new HashMap<String, Object>();
        constraint1.put("type", ConstraintType.UNIQUENESS.name());
        constraint1.put("label", labelName);
        constraint1.put("property_keys", Collections.singletonList(propertyKey1));
        HashMap<String, Object> constraint2 = new HashMap<String, Object>();
        constraint2.put("type", ConstraintType.NODE_PROPERTY_EXISTENCE.name());
        constraint2.put("label", labelName);
        constraint2.put("property_keys", Collections.singletonList(propertyKey2));
        Assert.assertThat((Object)serializedList, (Matcher)Matchers.hasItems((Object[])new Map[]{constraint1, constraint2}));
    }

    @Documented(value="Get all constraints.")
    @Test
    @GraphDescription.Graph(nodes={})
    public void get_constraints() throws JsonParseException {
        this.data.get();
        String labelName1 = (String)this.labels.newInstance();
        String propertyKey1 = (String)this.properties.newInstance();
        String labelName2 = (String)this.labels.newInstance();
        String propertyKey2 = (String)this.properties.newInstance();
        this.createLabelUniquenessPropertyConstraint(labelName1, propertyKey1);
        this.createLabelPropertyExistenceConstraint(labelName2, propertyKey2);
        String result = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(this.getSchemaConstraintUri()).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        HashMap<String, Object> constraint1 = new HashMap<String, Object>();
        constraint1.put("type", ConstraintType.UNIQUENESS.name());
        constraint1.put("label", labelName1);
        constraint1.put("property_keys", Collections.singletonList(propertyKey1));
        HashMap<String, Object> constraint2 = new HashMap<String, Object>();
        constraint2.put("type", ConstraintType.NODE_PROPERTY_EXISTENCE.name());
        constraint2.put("label", labelName2);
        constraint2.put("property_keys", Collections.singletonList(propertyKey2));
        Assert.assertThat((Object)serializedList, (Matcher)Matchers.hasItems((Object[])new Map[]{constraint1, constraint2}));
    }

    private ConstraintDefinition createLabelUniquenessPropertyConstraint(String labelName, String propertyKey) {
        try (Transaction tx = this.graphdb().beginTx();){
            ConstraintDefinition constraintDefinition = this.graphdb().schema().constraintFor(Label.label((String)labelName)).assertPropertyIsUnique(propertyKey).create();
            tx.success();
            ConstraintDefinition constraintDefinition2 = constraintDefinition;
            return constraintDefinition2;
        }
    }

    private String getDataUri() {
        return "http://localhost:7474/db/data/";
    }

    public String getSchemaConstraintUri() {
        return this.getDataUri() + "schema/constraint";
    }

    public String getSchemaConstraintLabelUri(String label) {
        return this.getDataUri() + "schema/constraint" + "/" + label;
    }

    private void createLabelPropertyExistenceConstraint(String labelName, String propertyKey) {
        String query = String.format("CREATE CONSTRAINT ON (n:%s) ASSERT exists(n.%s)", labelName, propertyKey);
        this.graphdb().execute(query);
    }

    private void createRelationshipTypePropertyExistenceConstraint(String typeName, String propertyKey) {
        String query = String.format("CREATE CONSTRAINT ON ()-[r:%s]-() ASSERT exists(r.%s)", typeName, propertyKey);
        this.graphdb().execute(query);
    }

    private String getSchemaConstraintLabelExistenceUri(String label) {
        return this.getDataUri() + "schema/constraint" + "/" + label + "/existence/";
    }

    private String getSchemaRelationshipConstraintTypeExistenceUri(String type) {
        return this.getDataUri() + "schema/relationship/constraint" + "/" + type + "/existence/";
    }

    private String getSchemaConstraintLabelExistencePropertyUri(String label, String property) {
        return this.getDataUri() + "schema/constraint" + "/" + label + "/existence/" + property;
    }

    private String getSchemaRelationshipConstraintTypeExistencePropertyUri(String type, String property) {
        return this.getDataUri() + "schema/relationship/constraint" + "/" + type + "/existence/" + property;
    }
}

