/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.codehaus.jackson.JsonNode;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.server.rest.security.AbstractRESTInteraction;
import org.neo4j.test.server.HTTP;

class CypherRESTInteraction
extends AbstractRESTInteraction {
    CypherRESTInteraction(Map<String, String> config) throws IOException {
        super(config);
    }

    @Override
    String commitPath() {
        return "db/data/cypher";
    }

    @Override
    HTTP.RawPayload constructQuery(String query) {
        return HTTP.RawPayload.quotedJson((String)(" { 'query': '" + query.replace("'", "\\'").replace("\"", "\\\"") + "' }"));
    }

    @Override
    void consume(Consumer<ResourceIterator<Map<String, Object>>> resultConsumer, JsonNode data) {
        if (data.has("data") && data.get("data").has(0)) {
            resultConsumer.accept(new CypherRESTResult(data));
        }
    }

    @Override
    protected HTTP.Response authenticate(String principalCredentials) {
        return HTTP.withHeaders((String[])new String[]{"Authorization", principalCredentials}).request("POST", this.commitURL(), (Object)this.constructQuery("RETURN 1"));
    }

    private class CypherRESTResult
    extends AbstractRESTInteraction.AbstractRESTResult {
        CypherRESTResult(JsonNode fullResult) {
            super(CypherRESTInteraction.this, fullResult);
        }

        @Override
        protected JsonNode getRow(JsonNode data, int i) {
            return data.get(i);
        }
    }
}

