/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.jackson.node.ArrayNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.server.enterprise.helpers.EnterpriseServerBuilder;
import org.neo4j.server.rest.security.AuthenticationIT;
import org.neo4j.test.server.HTTP;

public class EnterpriseAuthenticationIT
extends AuthenticationIT {
    public void startServer(boolean authEnabled) throws IOException {
        this.server = EnterpriseServerBuilder.server().withProperty(GraphDatabaseSettings.auth_enabled.name(), Boolean.toString(authEnabled)).build();
        this.server.start();
    }

    @Test
    public void shouldHavePredefinedRoles() throws Exception {
        this.startServerWithConfiguredUser();
        String method = "POST";
        String path = "db/data/transaction/commit";
        HTTP.RawPayload payload = HTTP.RawPayload.quotedJson((String)"{'statements':[{'statement':'CALL dbms.security.listRoles()'}]}");
        HTTP.Response response = HTTP.withHeaders((String[])new String[]{"Authorization", this.challengeResponse("neo4j", "secret")}).request(method, this.server.baseUri().resolve(path).toString(), (Object)payload);
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        ArrayNode errors = (ArrayNode)response.get("errors");
        Assert.assertThat((String)"Should have no errors", (Object)errors.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        ArrayNode results = (ArrayNode)response.get("results");
        ArrayNode data = (ArrayNode)results.get(0).get("data");
        Assert.assertThat((String)"Should have 5 predefined roles", (Object)data.size(), (Matcher)CoreMatchers.equalTo((Object)5));
        Stream<String> values = data.findValues("row").stream().map(row -> row.get(0).asText());
        Assert.assertThat((String)"Expected specific roles", values.collect(Collectors.toList()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"admin", "architect", "publisher", "editor", "reader"}));
    }

    @Test
    public void shouldAllowExecutingEnterpriseBuiltInProceduresWithAuthDisabled() throws Exception {
        this.startServerWithAuthDisabled();
        String method = "POST";
        String path = "db/data/transaction/commit";
        HTTP.RawPayload payload = HTTP.RawPayload.quotedJson((String)"{'statements':[{'statement':'CALL dbms.listQueries()'}]}");
        HTTP.Response response = HTTP.request((String)method, (String)this.server.baseUri().resolve(path).toString(), (Object)payload);
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        ArrayNode errors = (ArrayNode)response.get("errors");
        Assert.assertThat((String)"Should have no errors", (Object)errors.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        ArrayNode results = (ArrayNode)response.get("results");
        ArrayNode data = (ArrayNode)results.get(0).get("data");
        Assert.assertThat((String)"Should see our own query", (Object)data.size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    private void startServerWithAuthDisabled() throws IOException {
        this.server = EnterpriseServerBuilder.server().withProperty(GraphDatabaseSettings.auth_enabled.name(), Boolean.toString(false)).build();
        this.server.start();
    }
}

