/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Predicate;
import org.jboss.netty.channel.ChannelException;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.client.ClusterClientModule;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemLifecycleAdapter;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.StoreLogService;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.Bootstrapper;

public class ArbiterBootstrapper
implements Bootstrapper,
AutoCloseable {
    private final LifeSupport life = new LifeSupport();
    private final Timer timer = new Timer(true);

    @SafeVarargs
    public final int start(File homeDir, Optional<File> configFile, Pair<String, String> ... configOverrides) {
        Config config = ArbiterBootstrapper.getConfig(configFile, configOverrides);
        try {
            DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
            this.life.add((Lifecycle)new FileSystemLifecycleAdapter((FileSystemAbstraction)fileSystem));
            this.life.add((Lifecycle)new Neo4jJobScheduler());
            new ClusterClientModule(this.life, new Dependencies(), new Monitors(), config, ArbiterBootstrapper.logService((FileSystemAbstraction)fileSystem, config), (ElectionCredentialsProvider)new NotElectableElectionCredentialsProvider());
        }
        catch (LifecycleException e) {
            Throwable cause = Exceptions.peel((Throwable)e, (Predicate)Predicates.instanceOf(LifecycleException.class));
            if (cause instanceof ChannelException) {
                System.err.println("ERROR: " + cause.getMessage() + (cause.getCause() != null ? ", caused by:" + cause.getCause().getMessage() : ""));
            }
            System.err.println("ERROR: Unknown error");
            throw e;
        }
        this.addShutdownHook();
        this.life.start();
        return 0;
    }

    public int stop() {
        this.life.shutdown();
        return 0;
    }

    @Override
    public void close() {
        this.stop();
    }

    @SafeVarargs
    private static Config getConfig(Optional<File> configFile, Pair<String, String> ... configOverrides) {
        HashMap<String, String> config = new HashMap<String, String>();
        configFile.ifPresent(file -> {
            try {
                config.putAll(MapUtil.load((File)file));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load config file " + configFile, e);
            }
        });
        for (Pair<String, String> configOverride : configOverrides) {
            config.put((String)configOverride.first(), (String)configOverride.other());
        }
        ArbiterBootstrapper.verifyConfig(config);
        return Config.embeddedDefaults(config);
    }

    private static void verifyConfig(Map<String, String> config) {
        if (!config.containsKey(ClusterSettings.initial_hosts.name())) {
            throw new IllegalArgumentException("No initial hosts to connect to supplied");
        }
        if (!config.containsKey(ClusterSettings.server_id.name())) {
            throw new IllegalArgumentException("No server id specified");
        }
    }

    private static LogService logService(FileSystemAbstraction fileSystem, Config config) {
        File logDir = (File)config.get(GraphDatabaseSettings.logs_directory);
        try {
            return StoreLogService.withUserLogProvider((LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out)).inLogsDirectory(fileSystem, logDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ArbiterBootstrapper.this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        System.err.println("Failed to stop in a reasonable time, terminating...");
                        Runtime.getRuntime().halt(1);
                    }
                }, 4000L);
                ArbiterBootstrapper.this.stop();
            }
        });
    }
}

