/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.SystemUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.client.ClusterClientModule;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.ServerIdElectionCredentialsProvider;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.server.enterprise.ArbiterBootstrapperTestProxy;
import org.neo4j.server.enterprise.functional.DumpPortListenerOnNettyBindFailure;
import org.neo4j.test.InputStreamAwaiter;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.test.StreamConsumer;
import org.neo4j.test.rule.TestDirectory;

public class ArbiterBootstrapperIT {
    private static Integer SHOULD_NOT_JOIN = null;
    @Rule
    public TestRule dumpPorts = new DumpPortListenerOnNettyBindFailure();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private File directory;
    private LifeSupport life;
    private ClusterClient[] clients;

    @Test
    public void canJoinWithExplicitInitialHosts() throws Exception {
        this.startAndAssertJoined(5003, MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5001", ClusterSettings.server_id.name(), "3"}));
    }

    @Test
    public void willFailJoinIfIncorrectInitialHostsSet() throws Exception {
        Assume.assumeFalse((String)"Cannot kill processes on windows.", (boolean)SystemUtils.IS_OS_WINDOWS);
        this.startAndAssertJoined(SHOULD_NOT_JOIN, MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5011", ClusterSettings.server_id.name(), "3"}));
    }

    @Test
    public void canSetSpecificPort() throws Exception {
        this.startAndAssertJoined(5010, MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5001", ClusterSettings.server_id.name(), "3", ClusterSettings.cluster_server.name(), ":5010"}));
    }

    @Test
    public void usesPortRange() throws Exception {
        this.startAndAssertJoined(5012, MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5001", ClusterSettings.cluster_server.name(), ":5012-5020", ClusterSettings.server_id.name(), "3"}));
    }

    @Before
    public void before() throws Exception {
        this.directory = this.testDirectory.directory("temp");
        this.life = new LifeSupport();
        this.life.start();
        this.clients = new ClusterClient[2];
        for (int i = 1; i <= this.clients.length; ++i) {
            Map config = MapUtil.stringMap((String[])new String[0]);
            config.put(ClusterSettings.cluster_server.name(), ":" + (5000 + i));
            config.put(ClusterSettings.server_id.name(), "" + i);
            config.put(ClusterSettings.initial_hosts.name(), ":5001");
            LifeSupport moduleLife = new LifeSupport();
            ClusterClientModule clusterClientModule = new ClusterClientModule(moduleLife, new Dependencies(), new Monitors(), Config.embeddedDefaults((Map)config), (LogService)NullLogService.getInstance(), (ElectionCredentialsProvider)new ServerIdElectionCredentialsProvider());
            final ClusterClient client = clusterClientModule.clusterClient;
            final CountDownLatch latch = new CountDownLatch(1);
            client.addClusterListener((ClusterListener)new ClusterListener.Adapter(){

                public void enteredCluster(ClusterConfiguration configuration) {
                    latch.countDown();
                    client.removeClusterListener((ClusterListener)this);
                }
            });
            this.life.add((Lifecycle)moduleLife);
            this.clients[i - 1] = client;
            Assert.assertTrue((String)"Didn't join the cluster", (boolean)latch.await(20L, TimeUnit.SECONDS));
        }
    }

    @After
    public void after() throws Exception {
        this.life.shutdown();
    }

    private File writeConfig(Map<String, String> config) throws IOException {
        config.put(GraphDatabaseSettings.logs_directory.name(), this.directory.getPath());
        File configFile = new File(this.directory, "neo4j.conf");
        MapUtil.store(config, (File)configFile);
        return this.directory;
    }

    private void startAndAssertJoined(Integer expectedAssignedPort, Map<String, String> config) throws Exception {
        File configDir = this.writeConfig(config);
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger port = new AtomicInteger();
        this.clients[0].addClusterListener((ClusterListener)this.joinAwaitingListener(latch, port));
        boolean arbiterStarted = this.startArbiter(configDir, latch);
        if (expectedAssignedPort == null) {
            Assert.assertFalse((String)String.format("Should not be able to start arbiter given config file:%s", config), (boolean)arbiterStarted);
        } else {
            Assert.assertTrue((String)String.format("Should be able to start arbiter given config file:%s", config), (boolean)arbiterStarted);
            Assert.assertEquals((long)expectedAssignedPort.intValue(), (long)port.get());
        }
    }

    private ClusterListener.Adapter joinAwaitingListener(final CountDownLatch latch, final AtomicInteger port) {
        return new ClusterListener.Adapter(){

            public void joinedCluster(InstanceId member, URI memberUri) {
                port.set(memberUri.getPort());
                latch.countDown();
                ArbiterBootstrapperIT.this.clients[0].removeClusterListener((ClusterListener)this);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean startArbiter(File configDir, CountDownLatch latch) throws Exception {
        Process process = null;
        ProcessStreamHandler handler = null;
        try {
            process = this.startArbiterProcess(configDir);
            new InputStreamAwaiter(process.getInputStream()).awaitLine("starting", 20L, TimeUnit.SECONDS);
            handler = new ProcessStreamHandler(process, false, "", StreamConsumer.IGNORE_FAILURES);
            handler.launch();
            boolean bl = latch.await(10L, TimeUnit.SECONDS);
            return bl;
        }
        finally {
            if (process != null) {
                try (OutputStream inputToOtherProcess = process.getOutputStream();){
                    inputToOtherProcess.write(0);
                    inputToOtherProcess.flush();
                }
                if (!process.waitFor(10L, TimeUnit.SECONDS)) {
                    ArbiterBootstrapperIT.kill(process);
                }
            }
            if (handler != null) {
                handler.done();
            }
        }
    }

    private Process startArbiterProcess(File configDir) throws Exception {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("java", "-cp", System.getProperty("java.class.path")));
        args.add(ArbiterBootstrapperTestProxy.class.getName());
        if (configDir != null) {
            args.add(String.format("--%s=%s", "config-dir", configDir));
        }
        return Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
    }

    private static void kill(Process process) throws NoSuchFieldException, IllegalAccessException, IOException, InterruptedException {
        if (SystemUtils.IS_OS_WINDOWS) {
            process.destroy();
        } else {
            int pid = ((Number)ArbiterBootstrapperIT.accessible(process.getClass().getDeclaredField("pid")).get(process)).intValue();
            new ProcessBuilder("kill", "-9", "" + pid).start().waitFor();
        }
    }

    private static <T extends AccessibleObject> T accessible(T obj) {
        obj.setAccessible(true);
        return obj;
    }
}

