/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.IOException;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.server.NeoServer;
import org.neo4j.server.enterprise.EnterpriseNeoServer;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.server.ha.EnterpriseServerHelper;

public class StandaloneHaInfoFunctionalTest {
    private static EnterpriseNeoServer server;
    @Rule
    public final TestDirectory target = TestDirectory.testDirectory();
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Before
    public void before() throws IOException {
        server = EnterpriseServerHelper.createNonPersistentServer(this.target.directory());
    }

    @After
    public void after() {
        if (server != null) {
            server.stop();
        }
    }

    @Test
    public void testHaDiscoveryOnStandaloneReturns403() throws Exception {
        FunctionalTestHelper helper = new FunctionalTestHelper((NeoServer)server);
        JaxRsResponse response = RestRequest.req().get(this.getBasePath(helper));
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    private String getBasePath(FunctionalTestHelper helper) {
        return helper.managementUri() + "/" + "server/ha";
    }

    @Test
    public void testIsMasterOnStandaloneReturns403() throws Exception {
        FunctionalTestHelper helper = new FunctionalTestHelper((NeoServer)server);
        JaxRsResponse response = RestRequest.req().get(this.getBasePath(helper) + "/master");
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    @Test
    public void testIsSlaveOnStandaloneReturns403() throws Exception {
        FunctionalTestHelper helper = new FunctionalTestHelper((NeoServer)server);
        JaxRsResponse response = RestRequest.req().get(this.getBasePath(helper) + "/slave");
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    @Test
    public void testDiscoveryListingOnStandaloneDoesNotContainHA() throws Exception {
        FunctionalTestHelper helper = new FunctionalTestHelper((NeoServer)server);
        JaxRsResponse response = RestRequest.req().get(helper.managementUri());
        Map map = JsonHelper.jsonToMap((String)response.getEntity());
        Assert.assertEquals((long)2L, (long)((Map)map.get("services")).size());
    }
}

