/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.causalclustering;

import java.net.URI;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.server.rest.causalclustering.CausalClusteringStatus;
import org.neo4j.server.rest.causalclustering.CausalClusteringStatusFactory;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;

public class ReadReplicaStatusTest {
    private CausalClusteringStatus status;

    @Before
    public void setup() throws Exception {
        OutputFormat output = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://base.local:1234/"), null);
        this.status = CausalClusteringStatusFactory.build((OutputFormat)output, (GraphDatabaseService)((GraphDatabaseService)Mockito.mock(ReadReplicaGraphDatabase.class)));
    }

    @Test
    public void testAnswers() throws Exception {
        Response available = this.status.available();
        Response readonly = this.status.readonly();
        Response writable = this.status.writable();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)available.getStatus());
        Assert.assertEquals((Object)"true", (Object)available.getEntity());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)readonly.getStatus());
        Assert.assertEquals((Object)"true", (Object)readonly.getEntity());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)writable.getStatus());
        Assert.assertEquals((Object)"false", (Object)writable.getEntity());
    }
}

