/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.server.rest.dbms.UserServiceTest;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.enterprise.auth.MultiRealmAuthManagerRule;
import org.neo4j.server.security.enterprise.auth.ShiroSubject;

public class EnterpriseUserServiceTest
extends UserServiceTest {
    @Rule
    public MultiRealmAuthManagerRule authManagerRule;

    public EnterpriseUserServiceTest() {
        this.authManagerRule = new MultiRealmAuthManagerRule(this.userRepository, (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class));
    }

    protected void setupAuthManagerAndSubject() {
        this.userManagerSupplier = this.authManagerRule.getManager();
        ShiroSubject shiroSubject = (ShiroSubject)Mockito.mock(ShiroSubject.class);
        Mockito.when((Object)shiroSubject.getPrincipal()).thenReturn((Object)"neo4j");
        this.neo4jContext = this.authManagerRule.makeSecurityContext(shiroSubject);
    }

    @Test
    public void shouldLogPasswordChange() throws Exception {
        this.shouldChangePasswordAndReturnSuccess();
        MultiRealmAuthManagerRule.FullSecurityLog fullLog = this.authManagerRule.getFullSecurityLog();
        fullLog.assertHasLine("neo4j", "changed password");
    }

    @Test
    public void shouldLogFailedPasswordChange() throws Exception {
        this.shouldReturn422IfPasswordIdentical();
        MultiRealmAuthManagerRule.FullSecurityLog fullLog = this.authManagerRule.getFullSecurityLog();
        fullLog.assertHasLine("neo4j", "tried to change password: Old password and new password cannot be the same.");
    }
}

