/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.com.ports.allocation.PortAuthority;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.LegacySslPolicyConfig;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.BaseBootstrapperTestIT;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.NeoServer;
import org.neo4j.server.ServerBootstrapper;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.enterprise.OpenEnterpriseBootstrapper;
import org.neo4j.test.rule.CleanupRule;

public class OpenEnterpriseBootstrapperTestIT
extends BaseBootstrapperTestIT {
    private final TemporaryFolder folder = new TemporaryFolder();
    private final CleanupRule cleanupRule = new CleanupRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.folder).around((TestRule)this.cleanupRule);

    protected ServerBootstrapper newBootstrapper() {
        return new OpenEnterpriseBootstrapper();
    }

    @Test
    public void shouldBeAbleToStartInSingleMode() throws Exception {
        int resultCode = ServerBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.tempDir.newFolder("home-dir").getAbsolutePath(), "-c", this.configOption(ClusterSettings.mode, "SINGLE"), "-c", this.configOption(DatabaseManagementSystemSettings.data_directory, ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)DatabaseManagementSystemSettings.data_directory)), "-c", this.configOption(GraphDatabaseSettings.logs_directory, this.tempDir.getRoot().getAbsolutePath()), "-c", this.configOption(LegacySslPolicyConfig.certificates_directory, ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)LegacySslPolicyConfig.certificates_directory)), "-c", this.configOption(ServerSettings.script_enabled, "true"), "-c", this.configOption(OnlineBackupSettings.online_backup_server, "127.0.0.1:0"), "-c", new BoltConnector((String)"bolt").listen_address.name() + "=localhost:0", "-c", "dbms.connector.https.listen_address=localhost:0", "-c", "dbms.connector.1.type=HTTP", "-c", "dbms.connector.1.listen_address=localhost:0", "-c", "dbms.connector.1.encryption=NONE", "-c", "dbms.connector.1.enabled=true"});
        Assert.assertEquals((long)0L, (long)resultCode);
        org.neo4j.test.assertion.Assert.assertEventually((String)"Server was not started", () -> ((ServerBootstrapper)this.bootstrapper).isRunning(), (Matcher)Matchers.is((Object)true), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    @Test
    public void shouldBeAbleToStartInHAMode() throws Exception {
        int clusterPort = PortAuthority.allocatePort();
        int resultCode = ServerBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.tempDir.newFolder("home-dir").getAbsolutePath(), "-c", this.configOption(ClusterSettings.mode, "HA"), "-c", this.configOption(ClusterSettings.server_id, "1"), "-c", this.configOption(ClusterSettings.initial_hosts, "127.0.0.1:" + clusterPort), "-c", this.configOption(ClusterSettings.cluster_server, "127.0.0.1:" + clusterPort), "-c", this.configOption(DatabaseManagementSystemSettings.data_directory, ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)DatabaseManagementSystemSettings.data_directory)), "-c", this.configOption(GraphDatabaseSettings.logs_directory, this.tempDir.getRoot().getAbsolutePath()), "-c", this.configOption(LegacySslPolicyConfig.certificates_directory, ServerTestUtils.getRelativePath((File)this.folder.getRoot(), (Setting)LegacySslPolicyConfig.certificates_directory)), "-c", this.configOption(ServerSettings.script_enabled, "true"), "-c", this.configOption(OnlineBackupSettings.online_backup_server, "127.0.0.1:0"), "-c", new BoltConnector((String)"bolt").listen_address.name() + "=localhost:0", "-c", "dbms.connector.https.listen_address=localhost:0", "-c", "dbms.connector.1.type=HTTP", "-c", "dbms.connector.1.encryption=NONE", "-c", "dbms.connector.1.listen_address=localhost:0", "-c", "dbms.connector.1.enabled=true"});
        Assert.assertEquals((long)0L, (long)resultCode);
        org.neo4j.test.assertion.Assert.assertEventually((String)"Server was not started", () -> ((ServerBootstrapper)this.bootstrapper).isRunning(), (Matcher)Matchers.is((Object)true), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    @Test
    public void debugLoggingDisabledByDefault() throws Exception {
        File configFile = this.tempDir.newFile("neo4j.conf");
        Map properties = MapUtil.stringMap((String[])new String[0]);
        properties.putAll(ServerTestUtils.getDefaultRelativeProperties());
        properties.put("dbms.connector.https.listen_address", "localhost:0");
        properties.put("dbms.connector.1.type", "HTTP");
        properties.put("dbms.connector.1.encryption", "NONE");
        properties.put("dbms.connector.1.listen_address", "localhost:0");
        properties.put("dbms.connector.1.enabled", "true");
        properties.put(new BoltConnector((String)"bolt").listen_address.name(), "localhost:0");
        properties.put(OnlineBackupSettings.online_backup_server.name(), "127.0.0.1:0");
        MapUtil.store((Map)properties, (File)configFile);
        UncoveredEnterpriseBootstrapper uncoveredEnterpriseBootstrapper = new UncoveredEnterpriseBootstrapper();
        this.cleanupRule.add((Object)uncoveredEnterpriseBootstrapper);
        ServerBootstrapper.start((Bootstrapper)uncoveredEnterpriseBootstrapper, (String[])new String[]{"--home-dir", this.tempDir.newFolder("home-dir").getAbsolutePath(), "--config-dir", configFile.getParentFile().getAbsolutePath()});
        org.neo4j.test.assertion.Assert.assertEventually((String)"Server was started", () -> ((UncoveredEnterpriseBootstrapper)uncoveredEnterpriseBootstrapper).isRunning(), (Matcher)Matchers.is((Object)true), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        LogProvider userLogProvider = uncoveredEnterpriseBootstrapper.getUserLogProvider();
        Assert.assertFalse((String)"Debug logging is disabled by default", (boolean)userLogProvider.getLog(((Object)((Object)this)).getClass()).isDebugEnabled());
    }

    @Test
    public void debugLoggingEnabledBySetting() throws Exception {
        File configFile = this.tempDir.newFile("neo4j.conf");
        Map properties = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.store_internal_log_level.name(), "DEBUG"});
        properties.putAll(ServerTestUtils.getDefaultRelativeProperties());
        properties.put("dbms.connector.https.listen_address", "localhost:0");
        properties.put("dbms.connector.1.type", "HTTP");
        properties.put("dbms.connector.1.encryption", "NONE");
        properties.put("dbms.connector.1.listen_address", "localhost:0");
        properties.put("dbms.connector.1.enabled", "true");
        properties.put(new BoltConnector((String)"bolt").listen_address.name(), "localhost:0");
        properties.put(OnlineBackupSettings.online_backup_server.name(), "127.0.0.1:0");
        MapUtil.store((Map)properties, (File)configFile);
        UncoveredEnterpriseBootstrapper uncoveredEnterpriseBootstrapper = new UncoveredEnterpriseBootstrapper();
        this.cleanupRule.add((Object)uncoveredEnterpriseBootstrapper);
        ServerBootstrapper.start((Bootstrapper)uncoveredEnterpriseBootstrapper, (String[])new String[]{"--home-dir", this.tempDir.newFolder("home-dir").getAbsolutePath(), "--config-dir", configFile.getParentFile().getAbsolutePath()});
        org.neo4j.test.assertion.Assert.assertEventually((String)"Server was started", () -> ((UncoveredEnterpriseBootstrapper)uncoveredEnterpriseBootstrapper).isRunning(), (Matcher)Matchers.is((Object)true), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        LogProvider userLogProvider = uncoveredEnterpriseBootstrapper.getUserLogProvider();
        Assert.assertTrue((String)"Debug logging enabled by setting value.", (boolean)userLogProvider.getLog(((Object)((Object)this)).getClass()).isDebugEnabled());
    }

    private class UncoveredEnterpriseBootstrapper
    extends OpenEnterpriseBootstrapper {
        private LogProvider userLogProvider;

        private UncoveredEnterpriseBootstrapper() {
        }

        protected NeoServer createNeoServer(Config configurator, GraphDatabaseDependencies dependencies, LogProvider userLogProvider) {
            this.userLogProvider = userLogProvider;
            return super.createNeoServer(configurator, dependencies, userLogProvider);
        }

        LogProvider getUserLogProvider() {
            return this.userLogProvider;
        }
    }
}

