/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.codehaus.jackson.JsonNode;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.server.rest.security.AbstractRESTInteraction;
import org.neo4j.test.server.HTTP;

class RESTInteraction
extends AbstractRESTInteraction {
    RESTInteraction(Map<String, String> config) throws IOException {
        super(config);
    }

    @Override
    String commitPath() {
        return "db/data/transaction/commit";
    }

    @Override
    HTTP.RawPayload constructQuery(String query) {
        return HTTP.RawPayload.quotedJson((String)("{'statements':[{'statement':'" + query.replace("'", "\\'").replace("\"", "\\\"") + "'}]}"));
    }

    @Override
    void consume(Consumer<ResourceIterator<Map<String, Object>>> resultConsumer, JsonNode data) {
        if (data.has("results") && data.get("results").has(0)) {
            resultConsumer.accept(new RESTResult(data.get("results").get(0)));
        }
    }

    @Override
    protected HTTP.Response authenticate(String principalCredentials) {
        return HTTP.withHeaders((String[])new String[]{"Authorization", principalCredentials}).request("POST", this.commitURL());
    }

    private class RESTResult
    extends AbstractRESTInteraction.AbstractRESTResult {
        RESTResult(JsonNode fullResult) {
            super(RESTInteraction.this, fullResult);
        }

        @Override
        protected JsonNode getRow(JsonNode data, int i) {
            return data.get(i).get("row");
        }
    }
}

