/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.functional;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.MetricsTestHelper;
import org.neo4j.metrics.source.server.ServerMetrics;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.enterprise.helpers.EnterpriseServerBuilder;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

public class ServerMetricsIT {
    @Rule
    public final TestDirectory folder = TestDirectory.testDirectory();
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldShowServerMetrics() throws Throwable {
        File metrics = this.folder.file("metrics");
        CommunityNeoServer server = EnterpriseServerBuilder.serverOnRandomPorts().usingDataDir(this.folder.graphDbDir().getAbsolutePath()).withProperty(MetricsSettings.metricsEnabled.name(), "true").withProperty(MetricsSettings.csvEnabled.name(), "true").withProperty(MetricsSettings.csvPath.name(), metrics.getPath()).withProperty(MetricsSettings.csvInterval.name(), "100ms").persistent().build();
        try {
            server.start();
            String host = "http://localhost:" + server.baseUri().getPort() + ServerSettings.rest_api_path.getDefaultValue() + "/transaction/commit";
            for (int i = 0; i < 5; ++i) {
                ClientResponse r = (ClientResponse)((WebResource.Builder)Client.create().resource(host).accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)"{ 'statements': [ { 'statement': 'CREATE ()' } ] }");
                Assert.assertEquals((long)200L, (long)r.getStatus());
            }
            ServerMetricsIT.assertMetricsExists(metrics, ServerMetrics.THREAD_JETTY_ALL);
            ServerMetricsIT.assertMetricsExists(metrics, ServerMetrics.THREAD_JETTY_IDLE);
        }
        finally {
            server.stop();
        }
    }

    private static void assertMetricsExists(File metricsPath, String metricsName) throws InterruptedException {
        File file = MetricsTestHelper.metricsCsv((File)metricsPath, (String)metricsName);
        org.neo4j.test.assertion.Assert.assertEventually(() -> ServerMetricsIT.threadCountReader(file), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private static Long threadCountReader(File file) throws InterruptedException {
        try {
            return MetricsTestHelper.readLongValue((File)file);
        }
        catch (IOException io) {
            throw new UncheckedIOException(io);
        }
    }
}

