/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.jmx;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.NeoServer;
import org.neo4j.server.enterprise.OpenEnterpriseNeoServer;
import org.neo4j.server.enterprise.helpers.EnterpriseServerBuilder;
import org.neo4j.server.enterprise.jmx.ServerManagement;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

public class ServerManagementIT {
    private final CleanupRule cleanup = new CleanupRule();
    private final TestDirectory baseDir = TestDirectory.testDirectory();
    private final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.suppressOutput).around((TestRule)this.baseDir).around((TestRule)this.cleanup);

    @Test
    public void shouldBeAbleToRestartServer() throws Exception {
        String dataDirectory1 = this.baseDir.directory("data1").getAbsolutePath();
        String dataDirectory2 = this.baseDir.directory("data2").getAbsolutePath();
        Config config = Config.fromFile((File)EnterpriseServerBuilder.serverOnRandomPorts().withDefaultDatabaseTuning().usingDataDir(dataDirectory1).createConfigFiles()).withHome(this.baseDir.directory()).withSetting(GraphDatabaseSettings.logs_directory, this.baseDir.directory("logs").getPath()).build();
        NeoServer server = (NeoServer)this.cleanup.add((Object)new OpenEnterpriseNeoServer(config, (GraphDatabaseFacadeFactory.Dependencies)ServerManagementIT.graphDbDependencies(), (LogProvider)NullLogProvider.getInstance()));
        server.start();
        Assert.assertNotNull((Object)server.getDatabase().getGraph());
        Assert.assertEquals((Object)((File)config.get(GraphDatabaseSettings.database_path)).getAbsolutePath(), (Object)server.getDatabase().getLocation().getAbsolutePath());
        config.augment(GraphDatabaseSettings.data_directory, dataDirectory2);
        ServerManagement bean = new ServerManagement(server);
        bean.restartServer();
        Assert.assertNotNull((Object)server.getDatabase().getGraph());
        Assert.assertEquals((Object)((File)config.get(GraphDatabaseSettings.database_path)).getAbsolutePath(), (Object)server.getDatabase().getLocation().getAbsolutePath());
    }

    private static GraphDatabaseDependencies graphDbDependencies() {
        return GraphDatabaseDependencies.newDependencies().userLogProvider((LogProvider)NullLogProvider.getInstance());
    }
}

