/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.functional;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.enterprise.configuration.EnterpriseEditionSettings;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.enterprise.helpers.EnterpriseServerBuilder;
import org.neo4j.test.rule.SuppressOutput;

public class EnterpriseServerIT {
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder();
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToStartInHAMode() throws Throwable {
        int clusterPort = PortAuthority.allocatePort();
        CommunityNeoServer server = EnterpriseServerBuilder.serverOnRandomPorts().usingDataDir(this.folder.getRoot().getAbsolutePath()).withProperty(EnterpriseEditionSettings.mode.name(), "HA").withProperty(ClusterSettings.server_id.name(), "1").withProperty(ClusterSettings.cluster_server.name(), ":" + clusterPort).withProperty(ClusterSettings.initial_hosts.name(), ":" + clusterPort).persistent().build();
        try {
            server.start();
            server.getDatabase();
            Assert.assertThat((Object)server.getDatabase().getGraph(), (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(HighlyAvailableGraphDatabase.class)));
            Client client = Client.create();
            ClientResponse r = (ClientResponse)client.resource(this.getHaEndpoint((NeoServer)server)).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((long)200L, (long)r.getStatus());
            Assert.assertThat((Object)r.getEntity(String.class), (Matcher)Matchers.containsString((String)"master"));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRequireAuthorizationForHAStatusEndpoints() throws Exception {
        int clusterPort = PortAuthority.allocatePort();
        CommunityNeoServer server = EnterpriseServerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), "true").usingDataDir(this.folder.getRoot().getAbsolutePath()).withProperty(EnterpriseEditionSettings.mode.name(), "HA").withProperty(ClusterSettings.server_id.name(), "1").withProperty(ClusterSettings.cluster_server.name(), ":" + clusterPort).withProperty(ClusterSettings.initial_hosts.name(), ":" + clusterPort).persistent().build();
        try {
            server.start();
            server.getDatabase();
            Assert.assertThat((Object)server.getDatabase().getGraph(), (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(HighlyAvailableGraphDatabase.class)));
            Client client = Client.create();
            ClientResponse r = (ClientResponse)client.resource(this.getHaEndpoint((NeoServer)server)).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((long)401L, (long)r.getStatus());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAllowDisablingAuthorizationOnHAStatusEndpoints() throws Exception {
        int clusterPort = PortAuthority.allocatePort();
        CommunityNeoServer server = EnterpriseServerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), "true").withProperty(HaSettings.ha_status_auth_enabled.name(), "false").usingDataDir(this.folder.getRoot().getAbsolutePath()).withProperty(EnterpriseEditionSettings.mode.name(), "HA").withProperty(ClusterSettings.server_id.name(), "1").withProperty(ClusterSettings.cluster_server.name(), ":" + clusterPort).withProperty(ClusterSettings.initial_hosts.name(), ":" + clusterPort).persistent().build();
        try {
            server.start();
            server.getDatabase();
            Assert.assertThat((Object)server.getDatabase().getGraph(), (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(HighlyAvailableGraphDatabase.class)));
            Client client = Client.create();
            ClientResponse r = (ClientResponse)client.resource(this.getHaEndpoint((NeoServer)server)).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((long)200L, (long)r.getStatus());
            Assert.assertThat((Object)r.getEntity(String.class), (Matcher)Matchers.containsString((String)"master"));
        }
        finally {
            server.stop();
        }
    }

    private String getHaEndpoint(NeoServer server) {
        return server.baseUri().toString() + "db/manage/server/ha";
    }
}

