/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.helpers;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.enterprise.OpenEnterpriseNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.rest.web.DatabaseActions;

public class EnterpriseServerBuilder
extends CommunityServerBuilder {
    protected EnterpriseServerBuilder(LogProvider logProvider) {
        super(logProvider);
    }

    public static EnterpriseServerBuilder server() {
        return EnterpriseServerBuilder.server((LogProvider)NullLogProvider.getInstance());
    }

    public static EnterpriseServerBuilder serverOnRandomPorts() {
        EnterpriseServerBuilder server = EnterpriseServerBuilder.server();
        server.onRandomPorts();
        server.withProperty(new BoltConnector((String)"bolt").listen_address.name(), "localhost:0");
        server.withProperty(OnlineBackupSettings.online_backup_server.name(), ListenSocketAddress.listenAddress((String)"127.0.0.1", (int)PortAuthority.allocatePort()));
        return server;
    }

    public static EnterpriseServerBuilder server(LogProvider logProvider) {
        return new EnterpriseServerBuilder(logProvider);
    }

    public OpenEnterpriseNeoServer build() throws IOException {
        return (OpenEnterpriseNeoServer)super.build();
    }

    public EnterpriseServerBuilder usingDataDir(String dataDir) {
        super.usingDataDir(dataDir);
        return this;
    }

    protected CommunityNeoServer build(File configFile, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        return new TestEnterpriseNeoServer(config, configFile, dependencies, this.logProvider);
    }

    public Map<String, String> createConfiguration(File temporaryFolder) {
        Map configuration = super.createConfiguration(temporaryFolder);
        configuration.put(OnlineBackupSettings.online_backup_server.name(), ListenSocketAddress.listenAddress((String)"127.0.0.1", (int)PortAuthority.allocatePort()));
        configuration.putIfAbsent(MetricsSettings.csvPath.name(), new File(temporaryFolder, "metrics").getAbsolutePath());
        return configuration;
    }

    private class TestEnterpriseNeoServer
    extends OpenEnterpriseNeoServer {
        private final File configFile;

        TestEnterpriseNeoServer(Config config, File configFile, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
            super(config, dependencies, logProvider);
            this.configFile = configFile;
        }

        protected DatabaseActions createDatabaseActions() {
            return EnterpriseServerBuilder.this.createDatabaseActionsObject(this.database, this.getConfig());
        }

        public void stop() {
            super.stop();
            if (this.configFile != null) {
                this.configFile.delete();
            }
        }
    }
}

