/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.causalclustering;

import java.net.URI;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.server.rest.causalclustering.CausalClusteringStatus;
import org.neo4j.server.rest.causalclustering.CausalClusteringStatusFactory;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;

public class CoreStatusTest {
    private CoreGraphDatabase db;
    private CausalClusteringStatus status;

    @Before
    public void setup() throws Exception {
        OutputFormat output = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://base.local:1234/"), null);
        this.db = (CoreGraphDatabase)Mockito.mock(CoreGraphDatabase.class);
        this.status = CausalClusteringStatusFactory.build((OutputFormat)output, (GraphDatabaseService)this.db);
    }

    @Test
    public void testAnswersWhenLeader() {
        Mockito.when((Object)this.db.getRole()).thenReturn((Object)Role.LEADER);
        Response available = this.status.available();
        Response readonly = this.status.readonly();
        Response writable = this.status.writable();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)available.getStatus());
        Assert.assertEquals((Object)"true", (Object)available.getEntity());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)readonly.getStatus());
        Assert.assertEquals((Object)"false", (Object)readonly.getEntity());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)writable.getStatus());
        Assert.assertEquals((Object)"true", (Object)writable.getEntity());
    }

    @Test
    public void testAnswersWhenCandidate() {
        Mockito.when((Object)this.db.getRole()).thenReturn((Object)Role.CANDIDATE);
        Response available = this.status.available();
        Response readonly = this.status.readonly();
        Response writable = this.status.writable();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)available.getStatus());
        Assert.assertEquals((Object)"true", (Object)available.getEntity());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)readonly.getStatus());
        Assert.assertEquals((Object)"true", (Object)readonly.getEntity());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)writable.getStatus());
        Assert.assertEquals((Object)"false", (Object)writable.getEntity());
    }

    @Test
    public void testAnswersWhenFollower() {
        Mockito.when((Object)this.db.getRole()).thenReturn((Object)Role.FOLLOWER);
        Response available = this.status.available();
        Response readonly = this.status.readonly();
        Response writable = this.status.writable();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)available.getStatus());
        Assert.assertEquals((Object)"true", (Object)available.getEntity());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)readonly.getStatus());
        Assert.assertEquals((Object)"true", (Object)readonly.getEntity());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)writable.getStatus());
        Assert.assertEquals((Object)"false", (Object)writable.getEntity());
    }
}

