/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.causalclustering;

import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.server.rest.causalclustering.BaseStatus;
import org.neo4j.server.rest.causalclustering.CausalClusteringDiscovery;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;

class CoreStatus
extends BaseStatus {
    private final OutputFormat output;
    private final CoreGraphDatabase db;

    CoreStatus(OutputFormat output, CoreGraphDatabase db) {
        super(output);
        this.output = output;
        this.db = db;
    }

    @Override
    public Response discover() {
        return this.output.ok((Representation)new CausalClusteringDiscovery("server/causalclustering/"));
    }

    @Override
    public Response available() {
        return this.positiveResponse();
    }

    @Override
    public Response readonly() {
        Role role = this.db.getRole();
        return Stream.of(Role.FOLLOWER, Role.CANDIDATE).anyMatch(r -> r.equals((Object)role)) ? this.positiveResponse() : this.negativeResponse();
    }

    @Override
    public Response writable() {
        return this.db.getRole() == Role.LEADER ? this.positiveResponse() : this.negativeResponse();
    }
}

