/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.causalclustering;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.server.rest.causalclustering.CausalClusteringStatus;
import org.neo4j.server.rest.causalclustering.CausalClusteringStatusFactory;
import org.neo4j.server.rest.management.AdvertisableService;
import org.neo4j.server.rest.repr.OutputFormat;

@Path(value="server/causalclustering/")
public class CausalClusteringService
implements AdvertisableService {
    static final String BASE_PATH = "server/causalclustering/";
    static final String AVAILABLE = "available";
    static final String WRITABLE = "writable";
    static final String READ_ONLY = "read-only";
    private final CausalClusteringStatus status;

    public CausalClusteringService(@Context OutputFormat output, @Context GraphDatabaseService db) {
        this.status = CausalClusteringStatusFactory.build(output, db);
    }

    @GET
    public Response discover() {
        return this.status.discover();
    }

    @GET
    @Path(value="writable")
    public Response isWritable() {
        return this.status.writable();
    }

    @GET
    @Path(value="read-only")
    public Response isReadOnly() {
        return this.status.readonly();
    }

    @GET
    @Path(value="available")
    public Response isAvailable() {
        return this.status.available();
    }

    public String getName() {
        return "causalclustering";
    }

    public String getServerPath() {
        return BASE_PATH;
    }
}

