/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.causalclustering;

import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.neo4j.causalclustering.identity.MemberId;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ClusterStatusResponse {
    private final boolean isCore;
    private final long lastAppliedRaftIndex;
    private final boolean isParticipatingInRaftGroup;
    private final Collection<String> votingMembers;
    private final boolean isHealthy;
    private final String memberId;
    private final String leader;
    private final Long millisSinceLastLeaderMessage;

    ClusterStatusResponse(long lastAppliedRaftIndex, boolean isParticipatingInRaftGroup, Collection<MemberId> votingMembers, boolean isHealthy, MemberId memberId, MemberId leader, Duration millisSinceLastLeaderMessage, boolean isCore) {
        this.lastAppliedRaftIndex = lastAppliedRaftIndex;
        this.isParticipatingInRaftGroup = isParticipatingInRaftGroup;
        this.votingMembers = votingMembers.stream().map(member -> member.getUuid().toString()).sorted().collect(Collectors.toList());
        this.isHealthy = isHealthy;
        this.memberId = memberId.getUuid().toString();
        this.leader = Optional.ofNullable(leader).map(MemberId::getUuid).map(UUID::toString).orElse(null);
        this.millisSinceLastLeaderMessage = Optional.ofNullable(millisSinceLastLeaderMessage).map(Duration::toMillis).orElse(null);
        this.isCore = isCore;
    }

    public long getLastAppliedRaftIndex() {
        return this.lastAppliedRaftIndex;
    }

    public boolean isParticipatingInRaftGroup() {
        return this.isParticipatingInRaftGroup;
    }

    public Collection<String> getVotingMembers() {
        return this.votingMembers;
    }

    public boolean isHealthy() {
        return this.isHealthy;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public String getLeader() {
        return this.leader;
    }

    public Long getMillisSinceLastLeaderMessage() {
        return this.millisSinceLastLeaderMessage;
    }

    public boolean isCore() {
        return this.isCore;
    }
}

