/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.io.File;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.EnterpriseDiscoveryServiceFactorySelector;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.enterprise.EnterpriseGraphDatabase;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.enterprise.configuration.EnterpriseEditionSettings;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.database.GraphFactory;

public class EnterpriseGraphFactory
implements GraphFactory {
    public GraphDatabaseFacade newGraphDatabase(Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        EnterpriseEditionSettings.Mode mode = (EnterpriseEditionSettings.Mode)config.get(EnterpriseEditionSettings.mode);
        File storeDir = (File)config.get(GraphDatabaseSettings.databases_root_path);
        DiscoveryServiceFactory discoveryServiceFactory = new EnterpriseDiscoveryServiceFactorySelector().select(config);
        switch (mode) {
            case HA: {
                return new HighlyAvailableGraphDatabase(storeDir, config, dependencies);
            }
            case ARBITER: {
                throw new IllegalArgumentException("The server cannot be started in ARBITER mode.");
            }
            case CORE: {
                return new CoreGraphDatabase(storeDir, config, dependencies, discoveryServiceFactory);
            }
            case READ_REPLICA: {
                return new ReadReplicaGraphDatabase(storeDir, config, dependencies, discoveryServiceFactory);
            }
        }
        return new EnterpriseGraphDatabase(storeDir, config, dependencies);
    }
}

