/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.net.URI;
import java.time.Duration;
import java.util.function.Function;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.DocumentedDefaultValue;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Settings;

@Description(value="Settings available in the Enterprise server")
public class EnterpriseServerSettings
implements LoadableConfig {
    @Description(value="Configure the Neo4j Browser to time out logged in users after this idle period. Setting this to 0 indicates no limit.")
    public static final Setting<Duration> browser_credentialTimeout = Settings.setting((String)"browser.credential_timeout", (Function)Settings.DURATION, (String)"0");
    @Description(value="Configure the Neo4j Browser to store or not store user credentials.")
    public static final Setting<Boolean> browser_retainConnectionCredentials = Settings.setting((String)"browser.retain_connection_credentials", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="Configure the policy for outgoing Neo4j Browser connections.")
    public static final Setting<Boolean> browser_allowOutgoingBrowserConnections = Settings.setting((String)"browser.allow_outgoing_connections", (Function)Settings.BOOLEAN, (String)"true");
    @Internal
    @Description(value="Publicly discoverable bolt+routing:// URI to use for Neo4j Drivers wanting to access a cluster that this instance is a member of. Only applicable to causal clusters.")
    @DocumentedDefaultValue(value="Defaults to empty on any deployment that is not a causal cluster core, and a bolt+routing://-schemed URI of the advertised address of the first found bolt connector if the instance is a core member of a causal cluster.")
    public static final Setting<URI> bolt_routing_discoverable_address = Settings.setting((String)"unsupported.dbms.discoverable_bolt_routing_address", (Function)Settings.URI, (String)"");
}

