/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;
import org.neo4j.metrics.source.server.ServerThreadView;
import org.neo4j.metrics.source.server.ServerThreadViewSetter;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.database.EnterpriseGraphFactory;
import org.neo4j.server.database.GraphFactory;
import org.neo4j.server.enterprise.modules.EnterpriseAuthorizationModule;
import org.neo4j.server.enterprise.modules.JMXManagementModule;
import org.neo4j.server.modules.AuthorizationModule;
import org.neo4j.server.modules.DBMSModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.DatabaseRoleInfoServerModule;
import org.neo4j.server.rest.EnterpriseDiscoverableURIs;
import org.neo4j.server.rest.MasterInfoService;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.rest.management.AdvertisableService;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.server.web.WebServer;

public class OpenEnterpriseNeoServer
extends CommunityNeoServer {
    public OpenEnterpriseNeoServer(Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        super(config, (GraphFactory)new EnterpriseGraphFactory(), dependencies);
    }

    public OpenEnterpriseNeoServer(Config config, GraphFactory graphFactory, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        super(config, graphFactory, dependencies);
    }

    protected WebServer createWebServer() {
        Jetty9WebServer webServer = (Jetty9WebServer)super.createWebServer();
        webServer.setJettyCreatedCallback(jetty -> {
            final ThreadPool threadPool = jetty.getThreadPool();
            assert (threadPool != null);
            try {
                ServerThreadViewSetter setter = (ServerThreadViewSetter)this.database.getGraph().getDependencyResolver().resolveDependency(ServerThreadViewSetter.class);
                setter.set(new ServerThreadView(){

                    public int allThreads() {
                        return threadPool.getThreads();
                    }

                    public int idleThreads() {
                        return threadPool.getIdleThreads();
                    }
                });
            }
            catch (UnsatisfiedDependencyException unsatisfiedDependencyException) {
                // empty catch block
            }
        });
        return webServer;
    }

    protected AuthorizationModule createAuthorizationModule() {
        return new EnterpriseAuthorizationModule(this.webServer, this.authManagerSupplier, this.userLogProvider, this.getConfig(), this.getUriWhitelist());
    }

    protected DBMSModule createDBMSModule() {
        Supplier<DiscoverableURIs> discoverableURIs = () -> EnterpriseDiscoverableURIs.enterpriseDiscoverableURIs(this.getConfig(), (ConnectorPortRegister)this.getDependencyResolver().resolveDependency(ConnectorPortRegister.class));
        return new DBMSModule(this.webServer, this.getConfig(), discoverableURIs);
    }

    protected Iterable<ServerModule> createServerModules() {
        ArrayList<ServerModule> modules = new ArrayList<ServerModule>();
        modules.add(new DatabaseRoleInfoServerModule(this.webServer, this.getConfig(), this.userLogProvider));
        if (((Boolean)this.getConfig().get(ServerSettings.jmx_module_enabled)).booleanValue()) {
            modules.add(new JMXManagementModule((NeoServer)this));
        }
        super.createServerModules().forEach(modules::add);
        return modules;
    }

    public Iterable<AdvertisableService> getServices() {
        if (this.getDatabase().getGraph() instanceof HighlyAvailableGraphDatabase) {
            return Iterables.append((Object)new MasterInfoService(null, null), (Iterable)super.getServices());
        }
        return super.getServices();
    }

    protected Pattern[] getUriWhitelist() {
        ArrayList<Pattern> uriWhitelist = new ArrayList<Pattern>(Arrays.asList(super.getUriWhitelist()));
        if (!((Boolean)this.getConfig().get(HaSettings.ha_status_auth_enabled)).booleanValue()) {
            uriWhitelist.add(Pattern.compile("/db/manage/server/ha.*"));
        }
        if (!((Boolean)this.getConfig().get(CausalClusteringSettings.status_auth_enabled)).booleanValue()) {
            uriWhitelist.add(Pattern.compile("/db/manage/server/core.*"));
            uriWhitelist.add(Pattern.compile("/db/manage/server/read-replica.*"));
        }
        return uriWhitelist.toArray(new Pattern[uriWhitelist.size()]);
    }
}

