/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.causalclustering;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.core.consensus.DurationSinceLastMessageMonitor;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipManager;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.state.machines.id.CommandIndexTracker;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.server.rest.causalclustering.BaseStatus;
import org.neo4j.server.rest.causalclustering.CausalClusteringDiscovery;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;

class CoreStatus
extends BaseStatus {
    private final OutputFormat output;
    private final CoreGraphDatabase db;
    private final RaftMembershipManager raftMembershipManager;
    private final DatabaseHealth databaseHealth;
    private final TopologyService topologyService;
    private final DurationSinceLastMessageMonitor raftMessageTimerResetMonitor;
    private final RaftMachine raftMachine;
    private final CommandIndexTracker commandIndexTracker;

    CoreStatus(OutputFormat output, CoreGraphDatabase db) {
        super(output);
        this.output = output;
        this.db = db;
        DependencyResolver dependencyResolver = db.getDependencyResolver();
        this.raftMembershipManager = (RaftMembershipManager)dependencyResolver.resolveDependency(RaftMembershipManager.class);
        this.databaseHealth = (DatabaseHealth)dependencyResolver.resolveDependency(DatabaseHealth.class);
        this.topologyService = (TopologyService)dependencyResolver.resolveDependency(TopologyService.class);
        this.raftMachine = (RaftMachine)dependencyResolver.resolveDependency(RaftMachine.class);
        this.raftMessageTimerResetMonitor = (DurationSinceLastMessageMonitor)dependencyResolver.resolveDependency(DurationSinceLastMessageMonitor.class);
        this.commandIndexTracker = (CommandIndexTracker)dependencyResolver.resolveDependency(CommandIndexTracker.class);
    }

    @Override
    public Response discover() {
        return this.output.ok((Representation)new CausalClusteringDiscovery("server/causalclustering/"));
    }

    @Override
    public Response available() {
        return this.positiveResponse();
    }

    @Override
    public Response readonly() {
        Role role = this.db.getRole();
        return Arrays.asList(Role.FOLLOWER, Role.CANDIDATE).contains(role) ? this.positiveResponse() : this.negativeResponse();
    }

    @Override
    public Response writable() {
        return this.db.getRole() == Role.LEADER ? this.positiveResponse() : this.negativeResponse();
    }

    @Override
    public Response description() {
        MemberId myself = this.topologyService.myself();
        MemberId leader = this.getLeader();
        ArrayList<MemberId> votingMembers = new ArrayList<MemberId>(this.raftMembershipManager.votingMembers());
        boolean participatingInRaftGroup = votingMembers.contains(myself) && Objects.nonNull(leader);
        long lastAppliedRaftIndex = this.commandIndexTracker.getAppliedCommandIndex();
        Duration millisSinceLastLeaderMessage = this.raftMessageTimerResetMonitor.durationSinceLastMessage();
        return this.statusResponse(lastAppliedRaftIndex, participatingInRaftGroup, votingMembers, this.databaseHealth.isHealthy(), myself, leader, millisSinceLastLeaderMessage, true);
    }

    private MemberId getLeader() {
        try {
            return this.raftMachine.getLeader();
        }
        catch (NoLeaderFoundException e) {
            return null;
        }
    }
}

