/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.causalclustering;

import java.time.Duration;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.neo4j.causalclustering.core.state.machines.id.CommandIndexTracker;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.server.rest.causalclustering.BaseStatus;
import org.neo4j.server.rest.causalclustering.CausalClusteringDiscovery;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;

class ReadReplicaStatus
extends BaseStatus {
    private final OutputFormat output;
    private final TopologyService topologyService;
    private final DatabaseHealth dbHealth;
    private final CommandIndexTracker commandIndexTracker;

    ReadReplicaStatus(OutputFormat output, ReadReplicaGraphDatabase db) {
        super(output);
        this.output = output;
        DependencyResolver dependencyResolver = db.getDependencyResolver();
        this.commandIndexTracker = (CommandIndexTracker)dependencyResolver.resolveDependency(CommandIndexTracker.class);
        this.topologyService = (TopologyService)dependencyResolver.resolveDependency(TopologyService.class);
        this.dbHealth = (DatabaseHealth)dependencyResolver.resolveDependency(DatabaseHealth.class);
    }

    @Override
    public Response discover() {
        return this.output.ok((Representation)new CausalClusteringDiscovery("server/causalclustering/"));
    }

    @Override
    public Response available() {
        return this.positiveResponse();
    }

    @Override
    public Response readonly() {
        return this.positiveResponse();
    }

    @Override
    public Response writable() {
        return this.negativeResponse();
    }

    @Override
    public Response description() {
        Set<MemberId> votingMembers = this.topologyService.allCoreRoles().keySet();
        boolean isHealthy = this.dbHealth.isHealthy();
        MemberId memberId = this.topologyService.myself();
        MemberId leader = this.topologyService.allCoreRoles().keySet().stream().filter(member -> RoleInfo.LEADER.equals(this.topologyService.allCoreRoles().get(member))).findFirst().orElse(null);
        long lastAppliedRaftIndex = this.commandIndexTracker.getAppliedCommandIndex();
        Duration millisSinceLastLeaderMessage = null;
        return this.statusResponse(lastAppliedRaftIndex, false, votingMembers, isHealthy, memberId, leader, millisSinceLastLeaderMessage, false);
    }
}

