/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.MapRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationBasedMessageBodyWriter;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;

class MapRepresentationTest {
    MapRepresentationTest() {
    }

    @Test
    void shouldSerializeMapWithSimpleTypes() throws Exception {
        MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{"nulls", null, "strings", "a string", "numbers", 42, "booleans", true}));
        String serializedMap = RepresentationBasedMessageBodyWriter.serialize((Representation)rep, (RepresentationFormat)new JsonFormat(), (URI)new URI("http://localhost/"));
        Map map = JsonHelper.jsonToMap((String)serializedMap);
        Assertions.assertThat(map.get("nulls")).isNull();
        Assertions.assertThat((Map)map).containsEntry((Object)"strings", (Object)"a string");
        Assertions.assertThat((Map)map).containsEntry((Object)"numbers", (Object)42);
        Assertions.assertThat((Map)map).containsEntry((Object)"booleans", (Object)true);
    }

    @Test
    void shouldSerializeMapWithArrayTypes() throws Exception {
        MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{"strings", new String[]{"a string", "another string"}, "numbers", new int[]{42, 87}, "booleans", new boolean[]{true, false}, "Booleans", new Boolean[]{Boolean.TRUE, Boolean.FALSE}}));
        String serializedMap = RepresentationBasedMessageBodyWriter.serialize((Representation)rep, (RepresentationFormat)new JsonFormat(), (URI)new URI("http://localhost/"));
        Map map = JsonHelper.jsonToMap((String)serializedMap);
        Assertions.assertThat((Map)map).containsEntry((Object)"strings", Arrays.asList("a string", "another string"));
        Assertions.assertThat((Map)map).containsEntry((Object)"numbers", Arrays.asList(42, 87));
        Assertions.assertThat((Map)map).containsEntry((Object)"booleans", Arrays.asList(true, false));
        Assertions.assertThat((Map)map).containsEntry((Object)"Booleans", Arrays.asList(true, false));
    }

    @Test
    void shouldSerializeMapWithListsOfSimpleTypes() throws Exception {
        MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{"lists of nulls", Arrays.asList(null, null), "lists of strings", Arrays.asList("a string", "another string"), "lists of numbers", Arrays.asList(23, 87, 42), "lists of booleans", Arrays.asList(true, false, true)}));
        String serializedMap = RepresentationBasedMessageBodyWriter.serialize((Representation)rep, (RepresentationFormat)new JsonFormat(), (URI)new URI("http://localhost/"));
        Map map = JsonHelper.jsonToMap((String)serializedMap);
        Assertions.assertThat((Map)map).containsEntry((Object)"lists of nulls", Arrays.asList(null, null));
        Assertions.assertThat((Map)map).containsEntry((Object)"lists of strings", Arrays.asList("a string", "another string"));
        Assertions.assertThat((Map)map).containsEntry((Object)"lists of numbers", Arrays.asList(23, 87, 42));
        Assertions.assertThat((Map)map).containsEntry((Object)"lists of booleans", Arrays.asList(true, false, true));
    }

    @Test
    void shouldSerializeMapWithMapsOfSimpleTypes() throws Exception {
        MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{"maps with nulls", MapUtil.map((Object[])new Object[]{"nulls", null}), "maps with strings", MapUtil.map((Object[])new Object[]{"strings", "a string"}), "maps with numbers", MapUtil.map((Object[])new Object[]{"numbers", 42}), "maps with booleans", MapUtil.map((Object[])new Object[]{"booleans", true})}));
        String serializedMap = RepresentationBasedMessageBodyWriter.serialize((Representation)rep, (RepresentationFormat)new JsonFormat(), (URI)new URI("http://localhost/"));
        Map map = JsonHelper.jsonToMap((String)serializedMap);
        Assertions.assertThat(((Map)map.get("maps with nulls")).get("nulls")).isNull();
        Assertions.assertThat((Map)((Map)map.get("maps with strings"))).containsEntry((Object)"strings", (Object)"a string");
        Assertions.assertThat((Map)((Map)map.get("maps with numbers"))).containsEntry((Object)"numbers", (Object)42);
        Assertions.assertThat((Map)((Map)map.get("maps with booleans"))).containsEntry((Object)"booleans", (Object)true);
    }

    @Test
    void shouldSerializeArbitrarilyNestedMapsAndLists() throws Exception {
        MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{"a map with a list in it", MapUtil.map((Object[])new Object[]{"a list", Arrays.asList(42, 87)}), "a list with a map in it", Arrays.asList(MapUtil.map((Object[])new Object[]{"foo", "bar", "baz", false}))}));
        String serializedMap = RepresentationBasedMessageBodyWriter.serialize((Representation)rep, (RepresentationFormat)new JsonFormat(), (URI)new URI("http://localhost/"));
        Map map = JsonHelper.jsonToMap((String)serializedMap);
        Assertions.assertThat((Map)((Map)map.get("a map with a list in it"))).containsEntry((Object)"a list", List.of(Integer.valueOf(42), Integer.valueOf(87)));
        Assertions.assertThat((Map)((Map)((List)map.get("a list with a map in it")).get(0))).containsEntry((Object)"foo", (Object)"bar");
        Assertions.assertThat((Map)((Map)((List)map.get("a list with a map in it")).get(0))).containsEntry((Object)"baz", (Object)false);
    }

    @Test
    void shouldSerializeMapsWithNullKeys() throws Exception {
        Object[] values;
        for (Object value : values = new Object[]{null, "string", 42, true, new String[]{"a string", "another string"}, new int[]{42, 87}, new boolean[]{true, false}, Arrays.asList(true, false, true), MapUtil.map((Object[])new Object[]{"numbers", 42, null, "something"}), MapUtil.map((Object[])new Object[]{"a list", Arrays.asList(42, 87), null, Arrays.asList("a", "b")}), Arrays.asList(MapUtil.map((Object[])new Object[]{"foo", "bar", null, false}))}) {
            MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{null, value}));
            String serializedMap = RepresentationBasedMessageBodyWriter.serialize((Representation)rep, (RepresentationFormat)new JsonFormat(), (URI)new URI("http://localhost/"));
            Map map = JsonHelper.jsonToMap((String)serializedMap);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)map.size());
            Object actual = map.get("null");
            if (value == null) {
                org.junit.jupiter.api.Assertions.assertNull(actual);
                continue;
            }
            org.junit.jupiter.api.Assertions.assertNotNull(actual);
        }
    }
}

