/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Entity;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.PropertiesRepresentation;
import org.neo4j.server.rest.repr.RepresentationTestAccess;

class PropertiesRepresentationTest {
    PropertiesRepresentationTest() {
    }

    @Test
    void shouldContainAddedPropertiesWhenCreatedFromEntity() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("foo", "bar");
        Map serialized = RepresentationTestAccess.serialize((MappingRepresentation)new PropertiesRepresentation(PropertiesRepresentationTest.container(values)));
        Assertions.assertEquals((Object)"bar", serialized.get("foo"));
    }

    @Test
    void shouldSerializeToMapWithSamePropertiesWhenCreatedFromEntity() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("foo", "bar");
        PropertiesRepresentation properties = new PropertiesRepresentation(PropertiesRepresentationTest.container(values));
        Map map = RepresentationTestAccess.serialize((MappingRepresentation)properties);
        Assertions.assertEquals(values, (Object)map);
    }

    @Test
    void shouldSerializeToMap() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("string", "value");
        values.put("int", 5);
        values.put("long", 17L);
        values.put("double", 3.14);
        values.put("float", Float.valueOf(42.0f));
        values.put("string array", new String[]{"one", "two"});
        values.put("long array", new long[]{5L, 17L});
        values.put("double array", new double[]{3.14, 42.0});
        PropertiesRepresentation properties = new PropertiesRepresentation(PropertiesRepresentationTest.container(values));
        Map map = RepresentationTestAccess.serialize((MappingRepresentation)properties);
        Assertions.assertEquals((Object)"value", map.get("string"));
        Assertions.assertEquals((long)5L, (long)((Number)map.get("int")).longValue());
        Assertions.assertEquals((long)17L, (long)((Number)map.get("long")).longValue());
        Assertions.assertEquals((double)3.14, (double)((Number)map.get("double")).doubleValue(), (double)0.0);
        Assertions.assertEquals((double)42.0, (double)((Number)map.get("float")).doubleValue(), (double)0.0);
        PropertiesRepresentationTest.assertEqualContent(Arrays.asList("one", "two"), (List)map.get("string array"));
        PropertiesRepresentationTest.assertEqualContent(Arrays.asList(5L, 17L), (List)map.get("long array"));
        PropertiesRepresentationTest.assertEqualContent(Arrays.asList(3.14, 42.0), (List)map.get("double array"));
    }

    @Test
    void shouldBeAbleToSignalEmptiness() {
        PropertiesRepresentation properties = new PropertiesRepresentation(PropertiesRepresentationTest.container(new HashMap<String, Object>()));
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("key", "value");
        Assertions.assertTrue((boolean)properties.isEmpty());
        properties = new PropertiesRepresentation(PropertiesRepresentationTest.container(values));
        Assertions.assertFalse((boolean)properties.isEmpty());
    }

    private static void assertEqualContent(List<?> expected, List<?> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        Iterator<?> ex = expected.iterator();
        Iterator<?> ac = actual.iterator();
        while (ex.hasNext() && ac.hasNext()) {
            Assertions.assertEquals(ex.next(), ac.next());
        }
    }

    static Entity container(Map<String, Object> values) {
        Entity container = (Entity)Mockito.mock(Entity.class);
        Mockito.when((Object)container.getPropertyKeys()).thenReturn(values.keySet());
        Mockito.when((Object)container.getAllProperties()).thenReturn(values);
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Mockito.when((Object)container.getProperty(entry.getKey(), null)).thenReturn(entry.getValue());
        }
        return container;
    }
}

