/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.util.Base64;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.server.rest.dbms.AuthorizationHeaders;
import org.neo4j.test.server.HTTP;

class AuthorizationHeadersTest {
    AuthorizationHeadersTest() {
    }

    @Test
    void shouldParseBasicAuth() {
        String username = "jake";
        String password = "qwerty123456";
        String header = HTTP.basicAuthHeader((String)username, (String)password);
        AuthorizationHeaders.ParsedHeader parsed = AuthorizationHeaders.decode((String)header);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)parsed);
        org.junit.jupiter.api.Assertions.assertEquals((Object)username, (Object)parsed.values()[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)password, (Object)parsed.values()[1]);
    }

    @Test
    void shouldParseBearerAuth() {
        String token = "are-you-token-to-me?";
        String header = HTTP.bearerAuthHeader((String)token);
        AuthorizationHeaders.ParsedHeader parsed = AuthorizationHeaders.decode((String)header);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)parsed);
        Assertions.assertThat((int)parsed.values().length).isEqualTo(1);
        Assertions.assertThat((String)parsed.values()[0]).isEqualTo(token);
    }

    @Test
    void shouldHandleSadPaths() {
        org.junit.jupiter.api.Assertions.assertNull((Object)AuthorizationHeaders.decode((String)""));
        org.junit.jupiter.api.Assertions.assertNull((Object)AuthorizationHeaders.decode((String)"Basic"));
        org.junit.jupiter.api.Assertions.assertNull((Object)AuthorizationHeaders.decode((String)"Bearer"));
        org.junit.jupiter.api.Assertions.assertNull((Object)AuthorizationHeaders.decode((String)"Basic not valid value"));
        org.junit.jupiter.api.Assertions.assertNull((Object)AuthorizationHeaders.decode((String)"Bearer too many args"));
        org.junit.jupiter.api.Assertions.assertNull((Object)AuthorizationHeaders.decode((String)("Basic " + Base64.getEncoder().encodeToString("".getBytes()))));
        org.junit.jupiter.api.Assertions.assertNull((Object)AuthorizationHeaders.decode((String)("Bearer " + Base64.getEncoder().encodeToString("".getBytes()))));
    }
}

