/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.NeoServerWithEmbeddedWebServer;
import org.neo4j.server.helpers.ServerBuilder;
import org.neo4j.server.logging.InMemoryAppender;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class NeoServerPortConflictFunctionalTest
extends ExclusiveServerTestBase {
    @Test
    public void shouldComplainIfServerPortIsAlreadyTaken() throws IOException {
        int contestedPort = 9999;
        ServerSocket socket = new ServerSocket(contestedPort, 0, InetAddress.getByName("0.0.0.0"));
        InMemoryAppender appender = new InMemoryAppender(NeoServerWithEmbeddedWebServer.log);
        NeoServerWithEmbeddedWebServer server = ServerBuilder.server().onPort(contestedPort).onHost("0.0.0.0").build();
        server.start();
        Assert.assertThat((Object)appender.toString(), (Matcher)Matchers.containsString((String)String.format(": Failed to start Neo Server", new Object[0])));
        socket.close();
        server.stop();
    }
}

