/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import com.sun.jersey.api.client.Client;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.NeoServer;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.GraphDbHelper;

public final class FunctionalTestHelper {
    private final NeoServer server;
    private final GraphDbHelper helper;
    public static final Client CLIENT = Client.create();
    private RestRequest request;

    public FunctionalTestHelper(NeoServer server) {
        if (server.getDatabase() == null) {
            throw new RuntimeException("Server must be started before using " + this.getClass().getName());
        }
        this.helper = new GraphDbHelper(server.getDatabase());
        this.server = server;
        this.request = new RestRequest(server.baseUri().resolve("db/data/"));
    }

    public static Matcher<String[]> arrayContains(final String element) {
        return new TypeSafeMatcher<String[]>(){
            private String[] array;

            public void describeTo(Description descr) {
                descr.appendText("The array ").appendText(Arrays.toString(this.array)).appendText(" does not contain <").appendText(element).appendText(">");
            }

            public boolean matchesSafely(String[] array) {
                this.array = array;
                for (String string : array) {
                    if (!(element == null ? string == null : element.equals(string))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public GraphDbHelper getGraphDbHelper() {
        return this.helper;
    }

    public String dataUri() {
        return this.server.baseUri().toString() + "db/data/";
    }

    public String nodeUri() {
        return this.dataUri() + "node";
    }

    public String nodeUri(long id) {
        return this.nodeUri() + "/" + id;
    }

    public String nodePropertiesUri(long id) {
        return this.nodeUri(id) + "/properties";
    }

    public String nodePropertyUri(long id, String key) {
        return this.nodePropertiesUri(id) + "/" + key;
    }

    String relationshipUri() {
        return this.dataUri() + "relationship";
    }

    public String relationshipUri(long id) {
        return this.relationshipUri() + "/" + id;
    }

    public String relationshipPropertiesUri(long id) {
        return this.relationshipUri(id) + "/properties";
    }

    String relationshipPropertyUri(long id, String key) {
        return this.relationshipPropertiesUri(id) + "/" + key;
    }

    public String relationshipsUri(long nodeId, String dir, String ... types) {
        StringBuilder typesString = new StringBuilder();
        for (String type : types) {
            typesString.append(typesString.length() > 0 ? "&" : "");
            typesString.append(type);
        }
        return this.nodeUri(nodeId) + "/relationships/" + dir + "/" + typesString;
    }

    public String indexUri() {
        return this.dataUri() + "index/";
    }

    String nodeAutoIndexUri() {
        return this.indexUri() + "auto/node/";
    }

    String relationshipAutoIndexUri() {
        return this.indexUri() + "auto/relationship/";
    }

    public String nodeIndexUri() {
        return this.indexUri() + "node/";
    }

    public String relationshipIndexUri() {
        return this.indexUri() + "relationship/";
    }

    public String mangementUri() {
        return this.server.baseUri().toString() + "db/manage";
    }

    public String indexNodeUri(String indexName) {
        return this.nodeIndexUri() + indexName;
    }

    public String indexNodeUri(String indexName, String key, Object value) {
        return this.indexNodeUri(indexName) + "/" + key + "/" + value;
    }

    public String indexRelationshipUri(String indexName) {
        return this.relationshipIndexUri() + indexName;
    }

    public String indexRelationshipUri(String indexName, String key, Object value) {
        return this.indexRelationshipUri(indexName) + "/" + key + "/" + value;
    }

    public String extensionUri() {
        return this.dataUri() + "ext";
    }

    String extensionUri(String name) {
        return this.extensionUri() + "/" + name;
    }

    String graphdbExtensionUri(String name, String method) {
        return this.extensionUri(name) + "/graphdb/" + method;
    }

    String nodeExtensionUri(String name, String method, long id) {
        return this.extensionUri(name) + "/node/" + id + "/" + method;
    }

    String relationshipExtensionUri(String name, String method, long id) {
        return this.extensionUri(name) + "/relationship/" + id + "/" + method;
    }

    public GraphDatabaseAPI getDatabase() {
        return this.server.getDatabase().graph;
    }

    public String getWebadminUri() {
        return this.server.baseUri().toString() + "webadmin";
    }

    public JaxRsResponse get(String path) {
        return this.request.get(path);
    }

    public JaxRsResponse get(String path, String data) {
        return this.request.get(path, data);
    }

    public JaxRsResponse delete(String path) {
        return this.request.delete(path);
    }

    public JaxRsResponse post(String path, String data) {
        return this.request.post(path, data);
    }

    public void put(String path, String data) {
        this.request.put(path, data);
    }

    public long getNodeIdFromUri(String nodeUri) {
        return Long.valueOf(nodeUri.substring(nodeUri.lastIndexOf("/") + 1, nodeUri.length()));
    }

    public long getRelationshipIdFromUri(String relationshipUri) {
        return this.getNodeIdFromUri(relationshipUri);
    }

    public Map<String, Object> removeAnyAutoIndex(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Map innerMap = (Map)entry.getValue();
            String template = innerMap.get("template").toString();
            if (template.contains("index/auto/{type}".replace("{type}", "node")) || template.contains("index/auto/{type}".replace("{type}", "relationship")) || template.contains("_auto_")) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public URI baseUri() {
        return this.server.baseUri();
    }
}

