/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.neo4j.server.webdriver.WebDriverFacade;
import org.neo4j.server.webdriver.WebadminWebdriverLibrary;
import org.neo4j.test.JavaTestDocsGenerator;
import org.neo4j.test.TestData;
import org.neo4j.test.server.SharedServerTestBase;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public abstract class AbstractWebadminTest
extends SharedServerTestBase {
    @Rule
    public TestData<JavaTestDocsGenerator> gen = TestData.producedThrough((TestData.Producer)JavaTestDocsGenerator.PRODUCER);
    protected static WebadminWebdriverLibrary wl;
    private static WebDriverFacade webdriverFacade;

    @BeforeClass
    public static void setup() throws Exception {
        webdriverFacade = new WebDriverFacade();
        wl = new WebadminWebdriverLibrary(webdriverFacade, AbstractWebadminTest.deriveBaseUri());
    }

    private static String deriveBaseUri() {
        String overrideBaseUri = System.getProperty("webdriver.override.neo-server.baseuri");
        if (StringUtils.isNotEmpty((String)overrideBaseUri)) {
            return overrideBaseUri;
        }
        return AbstractWebadminTest.server().baseUri().toString();
    }

    @After
    public void doc() {
        ((JavaTestDocsGenerator)this.gen.get()).document("target/docs", "webadmin");
    }

    protected void captureScreenshot(String string) {
        WebDriver webDriver = wl.getWebDriver();
        if (webDriver instanceof TakesScreenshot) {
            try {
                File screenshotFile = (File)((TakesScreenshot)webDriver).getScreenshotAs(OutputType.FILE);
                System.out.println(screenshotFile.getAbsolutePath());
                File dir = new File("target/docs/webadmin/images");
                dir.mkdirs();
                String imageName = string + ".png";
                AbstractWebadminTest.copyFile(screenshotFile, new File(dir, imageName));
                ((JavaTestDocsGenerator)this.gen.get()).addImageSnippet(string, imageName, ((JavaTestDocsGenerator)this.gen.get()).getTitle());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Before
    public void cleanTheDatabase() {
        this.cleanDatabase();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        webdriverFacade.quitBrowser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }
}

