/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.Arrays;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.EmbeddedServerConfigurator;
import org.neo4j.server.database.GraphDatabaseFactory;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.DiscoveryModule;
import org.neo4j.server.modules.ManagementApiModule;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.modules.ThirdPartyJAXRSModule;
import org.neo4j.server.modules.WebAdminModule;
import org.neo4j.server.startup.healthcheck.StartupHealthCheckRule;

public class WrappingNeoServerBootstrapper
extends Bootstrapper {
    private final GraphDatabaseAPI db;
    private final Configurator configurator;
    private static Logger log = Logger.getLogger(WrappingNeoServerBootstrapper.class);

    public WrappingNeoServerBootstrapper(GraphDatabaseAPI db) {
        this(db, new EmbeddedServerConfigurator(db));
    }

    public WrappingNeoServerBootstrapper(GraphDatabaseAPI db, Configurator configurator) {
        this.db = db;
        this.configurator = configurator;
    }

    @Override
    public Iterable<StartupHealthCheckRule> getHealthCheckRules() {
        return Arrays.asList(new Object[0]);
    }

    @Override
    public Iterable<Class<? extends ServerModule>> getServerModules() {
        return Arrays.asList(DiscoveryModule.class, RESTApiModule.class, ManagementApiModule.class, ThirdPartyJAXRSModule.class, WebAdminModule.class);
    }

    @Override
    public int stop(int stopArg) {
        try {
            if (this.server != null) {
                this.server.stopServer();
                this.server.getDatabase().rrdDb().close();
            }
            return 0;
        }
        catch (Exception e) {
            log.error("Failed to cleanly shutdown Neo Server on port [%d]. Reason [%s] ", this.server.getWebServerPort(), e.getMessage());
            return 1;
        }
    }

    @Override
    protected void addShutdownHook() {
    }

    @Override
    protected GraphDatabaseFactory getGraphDatabaseFactory(Configuration configuration) {
        return new GraphDatabaseFactory(){

            @Override
            public GraphDatabaseAPI createDatabase(String databaseStoreDirectory, Map<String, String> databaseProperties) {
                return WrappingNeoServerBootstrapper.this.db;
            }
        };
    }

    @Override
    protected Configurator getConfigurator() {
        return this.configurator;
    }
}

