/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.JAXRSHelper;
import org.neo4j.server.NeoServerWithEmbeddedWebServer;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.ServerModule;

public class ManagementApiModule
implements ServerModule {
    private final Logger log = Logger.getLogger(ManagementApiModule.class);

    @Override
    public void start(NeoServerWithEmbeddedWebServer neoServer, StringLogger logger) {
        try {
            neoServer.getWebServer().addJAXRSPackages(JAXRSHelper.listFrom(new String[]{"org.neo4j.server.webadmin.rest"}), this.managementApiUri(neoServer).toString());
            this.log.info("Mounted management API at [%s]", this.managementApiUri(neoServer).toString());
            if (logger != null) {
                logger.logMessage("Mounted management API at: " + this.managementApiUri(neoServer).toString());
            }
        }
        catch (UnknownHostException e) {
            this.log.warn(e);
        }
    }

    @Override
    public void stop() {
    }

    private URI managementApiUri(NeoServerWithEmbeddedWebServer neoServer) throws UnknownHostException {
        try {
            return new URI(neoServer.getConfiguration().getString("org.neo4j.server.webadmin.management.uri", "/db/manage"));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

