/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.rest.repr.FullPathRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.RepresentationType;

public enum TraverserReturnType {
    node(RepresentationType.NODE){

        @Override
        public MappingRepresentation toRepresentation(Path position) {
            return new NodeRepresentation(position.endNode());
        }
    }
    ,
    relationship(RepresentationType.RELATIONSHIP){

        @Override
        public MappingRepresentation toRepresentation(Path position) {
            Relationship lastRelationship = position.lastRelationship();
            return lastRelationship != null ? new RelationshipRepresentation(lastRelationship) : null;
        }
    }
    ,
    path(RepresentationType.PATH){

        @Override
        public MappingRepresentation toRepresentation(Path position) {
            return new PathRepresentation<Path>(position);
        }
    }
    ,
    fullpath(RepresentationType.FULL_PATH){

        @Override
        public MappingRepresentation toRepresentation(Path position) {
            return new FullPathRepresentation(position);
        }
    };

    public final RepresentationType repType;

    private TraverserReturnType(RepresentationType repType) {
        this.repType = repType;
    }

    public abstract MappingRepresentation toRepresentation(Path var1);
}

